/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.options.optionvalue;

import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.options.converter.ConversionException;
import at.mrdevelopment.toolkit.options.converter.Converter;
import at.mrdevelopment.toolkit.options.optionvalue.XSLOptionValue;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ElementAttributeOptionValue<T>
implements XSLOptionValue<T> {
    private Element element;
    private String attributeKey;
    private Converter<T, String> stringConverter;
    private final String defaultValue;
    private String stringValue = null;
    private String inheritatedValue = null;

    public ElementAttributeOptionValue(Element element, String attributeKey, String defaultValue, Converter<T, String> stringConverter) {
        this.element = element;
        this.attributeKey = attributeKey;
        this.defaultValue = defaultValue;
        this.stringConverter = stringConverter;
        this.stringValue = this.parseStringValue();
    }

    private String parseStringValue() {
        Element xslAttribute = this.getSpecifiedXSLAttribute();
        if (this.element.hasAttribute(this.attributeKey)) {
            return this.element.getAttribute(this.attributeKey);
        }
        if (xslAttribute != null) {
            try {
                TransformerFactory transFactory = TransformerFactory.newInstance();
                Transformer transformer = transFactory.newTransformer();
                StringWriter buffer = new StringWriter();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.transform(new DOMSource(xslAttribute), new StreamResult(buffer));
                String value = buffer.toString();
                int start = value.indexOf(">");
                int end = value.lastIndexOf("<");
                value = start + 1 < end - 1 ? value.substring(start + 1, end - 1) : "";
                value = value.replaceAll("\r", "");
                value = value.replace("\n", "");
                return StringUtils.normalizeSpace((String)value);
            }
            catch (TransformerConfigurationException e) {
                e.printStackTrace();
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        }
        return this.defaultValue;
    }

    private Element getSpecifiedXSLAttribute() {
        NodeList childNodes = this.element.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            String attributeName;
            Element childElement;
            Node node = childNodes.item(index);
            if (node.getNodeType() != 1 || !(childElement = (Element)node).getNodeName().equals("xsl:attribute") || !childElement.hasAttribute("name") || !(attributeName = childElement.getAttribute("name")).equals(this.attributeKey)) continue;
            return childElement;
        }
        return null;
    }

    @Override
    public void setValueFromString(String value) throws OptionException {
        if (value == null || value.equals(this.defaultValue) || value.isEmpty()) {
            this.removeAttribute();
        } else if (!value.equals(this.defaultValue)) {
            this.setAttribute(value);
        }
    }

    @Override
    public void set(T value) throws OptionException {
        try {
            if (value == null || this.stringConverter.convert(value).equals(this.defaultValue) || value.toString().isEmpty()) {
                this.removeAttribute();
            } else if (!value.equals(this.defaultValue)) {
                this.setAttribute(this.stringConverter.convert(value));
            }
        }
        catch (DOMException e) {
            throw new OptionException(e);
        }
    }

    private void setAttribute(String stringValue) {
        block8: {
            Element xslAttribute = this.getSpecifiedXSLAttribute();
            if (stringValue.contains("<xsl:value-of select")) {
                if (xslAttribute == null) {
                    this.element.removeAttribute(this.attributeKey);
                } else {
                    this.element.removeChild(xslAttribute);
                }
                try {
                    Element dummyElement = this.createDummyElement(stringValue);
                    Node importedNode = this.element.getOwnerDocument().importNode(dummyElement, true);
                    if (this.element.hasChildNodes()) {
                        this.element.insertBefore(importedNode, this.element.getFirstChild());
                        break block8;
                    }
                    this.element.appendChild(importedNode);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            } else {
                if (xslAttribute != null) {
                    this.removeAttribute();
                }
                this.element.setAttribute(this.attributeKey, stringValue);
            }
        }
        this.stringValue = stringValue;
    }

    private Element createDummyElement(String stringValue) throws ParserConfigurationException, SAXException, IOException {
        String dummyString = "<xsl:attribute name=\"" + this.attributeKey + "\">" + stringValue + "</xsl:attribute>";
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(dummyString)));
        return document.getDocumentElement();
    }

    private void removeAttribute() {
        Element xslAttribute = this.getSpecifiedXSLAttribute();
        this.stringValue = null;
        if (xslAttribute == null) {
            this.element.removeAttribute(this.attributeKey);
        } else {
            this.element.removeChild(xslAttribute);
        }
    }

    @Override
    public T get() throws OptionException {
        try {
            if (!this.element.hasAttribute(this.attributeKey)) {
                return null;
            }
            return this.stringConverter.reconvert(this.element.getAttribute(this.attributeKey));
        }
        catch (ConversionException exc) {
            throw new OptionException(exc.getMessage(), exc.getCause());
        }
    }

    @Override
    public String getValueAsString() {
        if ((this.stringValue == null || this.stringValue.equals(this.defaultValue)) && this.inheritatedValue != null) {
            return this.inheritatedValue;
        }
        return this.stringValue;
    }

    @Override
    public void setInheritatedValue(String inheritatedValue) {
        this.inheritatedValue = inheritatedValue;
    }
}

