/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.options.converter;

import at.mrdevelopment.toolkit.options.converter.ConversionException;
import at.mrdevelopment.toolkit.options.converter.Converter;

public class DoubleStringConverter
implements Converter<Double, String> {
    @Override
    public String convert(Double doubleValue) {
        if (doubleValue == null) {
            return null;
        }
        return "" + doubleValue;
    }

    @Override
    public Double reconvert(String stringValue) throws ConversionException {
        if (stringValue == null) {
            throw new ConversionException("Unable convert from String to Double: stringValue was null");
        }
        try {
            return Double.parseDouble(stringValue);
        }
        catch (NumberFormatException e) {
            throw new ConversionException("Unable convert from String to Double. Original message: " + e.getMessage(), e.getCause());
        }
    }
}

