/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.options.converter;

import at.mrdevelopment.toolkit.options.converter.ConversionException;
import at.mrdevelopment.toolkit.options.converter.Converter;
import java.awt.Dimension;

public class DimensionStringConverter
implements Converter<Dimension, String> {
    private static final String DIMENSION_DELIMITER = "x";

    @Override
    public String convert(Dimension dimensionValue) {
        if (dimensionValue == null) {
            return null;
        }
        return dimensionValue.width + DIMENSION_DELIMITER + dimensionValue.height;
    }

    @Override
    public Dimension reconvert(String stringValue) throws ConversionException {
        if (stringValue == null) {
            throw new ConversionException("Unable to convert from String to Dimension: stringValue was null");
        }
        String[] dimensions = stringValue.split(DIMENSION_DELIMITER);
        if (dimensions == null || dimensions.length != 2) {
            throw new ConversionException("Unable to convert from String to Dimension: Error while splitting dimension string");
        }
        try {
            int x = Integer.parseInt(dimensions[0].trim());
            int y = Integer.parseInt(dimensions[1].trim());
            return new Dimension(x, y);
        }
        catch (Exception e) {
            throw new ConversionException("Unable to convert from String to Dimension. Original message: " + e.getMessage(), e.getCause());
        }
    }
}

