/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.options.converter;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.options.converter.ConversionException;
import at.mrdevelopment.toolkit.options.converter.Converter;
import java.awt.Color;
import java.lang.reflect.Field;

public class ColorStringConverter
implements Converter<Color, String> {
    static ESLLogger logger = ESLLogger.getLogger(ColorStringConverter.class);
    private static final String DELIMITER = ";";
    private static final int NUM_PARAMS_IN_STRING_REPRESENTATION = 4;
    private static final String TRANSPARENT_COLOR_KEY = "transparent";
    private static final Color TRANSPARENT_COLOR = new Color(255, 255, 255, 0);

    @Override
    public String convert(Color colorValue) {
        Field[] colorFields;
        if (colorValue == null) {
            return null;
        }
        if (colorValue.equals(TRANSPARENT_COLOR)) {
            return TRANSPARENT_COLOR_KEY;
        }
        for (Field colorField : colorFields = Color.class.getFields()) {
            try {
                Color color;
                Object colorObject = colorField.get(null);
                if (!(colorObject instanceof Color) || !(color = (Color)colorObject).equals(colorValue)) continue;
                return colorField.getName();
            }
            catch (IllegalArgumentException exc) {
                logger.warn("Unable to convert from Color to String: %s", exc.getMessage());
                logger.logExceptionIfDebugEnabled(exc);
            }
            catch (IllegalAccessException exc) {
                logger.warn("Unable to convert from Color to String: %s", exc.getMessage());
                logger.logExceptionIfDebugEnabled(exc);
            }
        }
        return colorValue.getRed() + DELIMITER + colorValue.getGreen() + DELIMITER + colorValue.getBlue() + DELIMITER + colorValue.getAlpha();
    }

    @Override
    public Color reconvert(String stringValue) throws ConversionException {
        if (stringValue == null) {
            throw new ConversionException("Unable to convert from String to Color: stringValue was null");
        }
        String[] splitValue = stringValue.split(DELIMITER);
        if (splitValue != null && splitValue.length == 4) {
            try {
                int r = Integer.parseInt(splitValue[0]);
                int g = Integer.parseInt(splitValue[1]);
                int b = Integer.parseInt(splitValue[2]);
                int a = Integer.parseInt(splitValue[3]);
                Color color = new Color(r, g, b, a);
                return color;
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Unable to convert from String to Color.", e.getCause());
            }
        }
        if (stringValue.toLowerCase().equals(TRANSPARENT_COLOR_KEY)) {
            return TRANSPARENT_COLOR;
        }
        try {
            Field colorField = Color.class.getField(stringValue.toUpperCase());
            Object colorObject = colorField.get(null);
            if (colorObject instanceof Color) {
                Color color = (Color)colorObject;
                return color;
            }
        }
        catch (IllegalArgumentException e) {
            throw new ConversionException("Unable to convert from String to Color.", e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new ConversionException("Unable to convert from String to Color.", e.getCause());
        }
        catch (SecurityException e) {
            throw new ConversionException("Unable to convert from String to Color.", e.getCause());
        }
        catch (NoSuchFieldException e) {
            throw new ConversionException("Unable to convert from String to Color.", e.getCause());
        }
        throw new ConversionException("Unable to convert from String to Color: stringValue can't be interpreted.");
    }
}

