/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.options.converter;

import at.mrdevelopment.toolkit.options.converter.ConversionException;
import at.mrdevelopment.toolkit.options.converter.Converter;

public class BooleanStringConverter
implements Converter<Boolean, String> {
    @Override
    public String convert(Boolean booleanValue) {
        if (booleanValue == null) {
            return null;
        }
        return booleanValue != false ? "true" : "false";
    }

    @Override
    public Boolean reconvert(String stringValue) throws ConversionException {
        if (stringValue == null) {
            throw new ConversionException("Unable to convert from String to Boolean: stringValue was null");
        }
        if (stringValue.equalsIgnoreCase("true") || stringValue.equalsIgnoreCase("yes") || stringValue.equalsIgnoreCase("on")) {
            return true;
        }
        if (stringValue.equalsIgnoreCase("false") || stringValue.equalsIgnoreCase("no") || stringValue.equalsIgnoreCase("off")) {
            return false;
        }
        throw new ConversionException("Unable to convert from String to Boolean: Invalid value [" + stringValue + "]");
    }
}

