/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.options.converter;

import at.mrdevelopment.toolkit.options.converter.ConversionException;
import at.mrdevelopment.toolkit.options.converter.Converter;
import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;

public class ArrayStringConverter<T>
implements Converter<T[], String> {
    private final Order order;
    private final Converter<T, String> valueConverter;
    private final String separator;

    public ArrayStringConverter(Converter<T, String> valueConverter) {
        this(valueConverter, Order.NONE);
    }

    public ArrayStringConverter(Converter<T, String> valueConverter, Order order) {
        this(valueConverter, Order.NONE, ",");
    }

    public ArrayStringConverter(Converter<T, String> valueConverter, Order order, String separator) {
        this.valueConverter = valueConverter;
        this.order = order;
        this.separator = separator;
    }

    @Override
    public String convert(T[] from) {
        if (this.order.equals((Object)Order.ASCENDING)) {
            Arrays.sort(from);
        } else if (this.order.equals((Object)Order.DESCENDING)) {
            Arrays.sort(from, Collections.reverseOrder());
        }
        if (from != null) {
            StringBuilder builder = new StringBuilder();
            for (int index = 0; index < from.length; ++index) {
                builder.append(from[index]);
                if (index >= from.length - 1) continue;
                builder.append(this.separator);
            }
            return builder.toString();
        }
        return null;
    }

    @Override
    public T[] reconvert(String to) throws ConversionException {
        String[] splittedValue = StringUtils.split((String)(StringUtils.isWhitespace((String)this.separator) ? to : StringUtils.deleteWhitespace((String)to)), (String)this.separator);
        Object[] array = new Object[splittedValue.length];
        for (int index = 0; index < splittedValue.length; ++index) {
            try {
                array[index] = this.valueConverter.reconvert(splittedValue[index]);
                continue;
            }
            catch (NumberFormatException exc) {
                throw new ConversionException(exc);
            }
        }
        if (this.order.equals((Object)Order.ASCENDING)) {
            Arrays.sort(array);
        } else if (this.order.equals((Object)Order.DESCENDING)) {
            Arrays.sort(array, Collections.reverseOrder());
        }
        return array;
    }

    public static enum Order {
        NONE,
        ASCENDING,
        DESCENDING;

    }
}

