/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.options;

import org.apache.commons.lang.StringUtils;

public class Size {
    private final String stringValue;
    private int intValue;
    private Unit unit;

    public Size(String value) {
        this.stringValue = value;
        this.parseValue();
    }

    private void parseValue() {
        String parsedValue = StringUtils.deleteWhitespace((String)this.stringValue);
        this.unit = parsedValue.endsWith(Unit.PERCENT.getUnitIdentifier()) ? Unit.PERCENT : Unit.PIXEL;
        parsedValue = StringUtils.removeEnd((String)parsedValue, (String)this.unit.getUnitIdentifier());
        try {
            this.intValue = Integer.valueOf(parsedValue);
        }
        catch (NumberFormatException exc) {
            this.intValue = 0;
        }
    }

    public int getIntValue() {
        return this.intValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public int getSize(int maxSize) {
        if (this.unit == Unit.PERCENT) {
            return (int)((float)maxSize * ((float)this.getIntValue() / 100.0f));
        }
        return this.getIntValue();
    }

    public boolean isEmpty() {
        return this.getIntValue() <= 0;
    }

    public boolean isOutOfBounds(int maxSize) {
        return this.getSize(maxSize) > maxSize;
    }

    public String toString() {
        return this.getStringValue();
    }

    public static enum Unit {
        PIXEL("px"),
        PERCENT("%");

        private final String unitIdentifier;

        private Unit(String unitIdentifier) {
            this.unitIdentifier = unitIdentifier;
        }

        public String getUnitIdentifier() {
            return this.unitIdentifier;
        }
    }
}

