/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.options;

import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.options.converter.ConversionException;
import at.mrdevelopment.toolkit.options.converter.Converter;
import at.mrdevelopment.toolkit.options.optionvalue.ElementAttributeOptionValue;
import at.mrdevelopment.toolkit.options.optionvalue.OptionValue;
import at.mrdevelopment.toolkit.options.optionvalue.OptionValueFactory;
import at.mrdevelopment.toolkit.options.optionvalue.OptionValueFactoryImpl;
import at.mrdevelopment.toolkit.options.optionvalue.XSLOptionValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class Option<T> {
    private boolean optional = false;
    private String key;
    private OptionValue<T> value;
    private OptionValue<T> defaultValue;
    private Source source;
    protected Converter<T, String> stringConverter;
    protected List<String> choices;
    private OptionValueFactory<T> optionValueFactory;
    private boolean valueChanged = false;

    public Option(String key, T defaultValue2, Converter<T, String> stringConverter) throws OptionException {
        if (key == null) {
            throw new OptionException("Key can't be null");
        }
        this.key = key;
        this.stringConverter = stringConverter;
        this.optionValueFactory = new OptionValueFactoryImpl<T>(stringConverter);
        if (defaultValue2 == null) {
            this.optional = true;
        }
        this.defaultValue = this.optionValueFactory.getOptionValue(OptionValueFactory.OptionValueType.FIELD, new Object[0]);
        this.defaultValue.set(defaultValue2);
        this.value = this.optionValueFactory.getOptionValue(OptionValueFactory.OptionValueType.FIELD, new Object[0]);
        this.value.set(defaultValue2);
        this.source = Source.NONE;
        this.choices = new ArrayList<String>();
    }

    public String getKey() {
        return this.key;
    }

    public void setOptionValue(OptionValue<T> optionValue) {
        if (optionValue != null) {
            this.value = optionValue;
        }
    }

    public void changeOptionValueType(OptionValueFactory.OptionValueType type, Object ... args) throws OptionException {
        String defValue = this.getDefaultValueAsString();
        if (args != null) {
            args = Arrays.copyOf(args, args.length + 1);
            args[args.length - 1] = defValue == null ? "" : defValue;
        }
        this.setOptionValue(this.optionValueFactory.getOptionValue(type, args));
    }

    public void set(T value) throws OptionException {
        this.valueChanged = true;
        this.value.set(value);
    }

    public T get() throws OptionException {
        return this.value.get();
    }

    public T getDefault() throws OptionException {
        return this.defaultValue.get();
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public Source getSource() {
        return this.source;
    }

    public Converter<T, String> getStringConverter() {
        return this.stringConverter;
    }

    public void setValueFromString(String valueAsString, boolean setChanged) throws OptionException {
        this.setValueFromString(valueAsString);
        this.valueChanged = !setChanged ? false : this.valueChanged;
    }

    public void setValueFromString(String valueAsString) throws OptionException {
        try {
            if (valueAsString == null) {
                this.set(null);
            } else if (this.value instanceof ElementAttributeOptionValue) {
                ((XSLOptionValue)this.value).setValueFromString(valueAsString);
            } else {
                this.set(this.stringConverter.reconvert(valueAsString));
            }
        }
        catch (ConversionException e) {
            if (this.optional) {
                this.set(null);
            }
            throw new OptionException(e.getMessage(), e.getCause());
        }
    }

    public String getValueAsString() throws OptionException {
        T value = this.get();
        if (value == null) {
            return null;
        }
        return this.stringConverter.convert(value);
    }

    public String getDefaultValueAsString() throws OptionException {
        return this.stringConverter.convert(this.getDefault());
    }

    public abstract void setFromObject(Object var1) throws OptionException;

    public abstract Object getAsObject() throws OptionException;

    public List<String> getChoices() {
        return Collections.unmodifiableList(this.choices);
    }

    public boolean isDefault() throws OptionException {
        return this.defaultValue == null || this.defaultValue.get() == null ? this.value == null || this.value.get() == null : this.defaultValue.get().equals(this.value.get());
    }

    public Class<?> getValueClass() throws OptionException {
        return this.get().getClass();
    }

    public boolean hasValueChanged() {
        return this.valueChanged;
    }

    public String toString() {
        Object value = null;
        try {
            value = this.get();
        }
        catch (OptionException e) {
            return "Exception while converting Option to String: Message=" + e.getMessage() + ", Cause=" + e.getCause();
        }
        String typeName = value != null ? value.getClass().getSimpleName() : "";
        String result = "[Option<" + typeName + "> [" + this.getKey() + " : " + value + "] Source:" + this.source.toString() + "]";
        return result;
    }

    public static enum Source {
        NONE,
        USER,
        SYSTEM;

    }
}

