/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.options;

import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.options.converter.EnumStringConverter;
import java.lang.reflect.Field;

public class EnumOption<T extends Enum<T>>
extends Option<Enum<?>> {
    public EnumOption(String key, Enum<T> defaultValue, Class<T> enumType) throws OptionException {
        super(key, defaultValue, new EnumStringConverter<T>(enumType));
        this.initChoices(enumType);
    }

    private void initChoices(Class<T> enumType) {
        this.choices.clear();
        for (Field field : enumType.getFields()) {
            this.choices.add(field.getName().toLowerCase());
        }
    }

    public Class<? extends Enum> getEnumClass() throws OptionException {
        return ((Enum)this.getDefault()).getClass();
    }

    @Override
    public void setValueFromString(String valueAsString) throws OptionException {
        try {
            super.setValueFromString(valueAsString);
        }
        catch (OptionException exc) {
            StringBuilder builder = new StringBuilder("'%s' is not a valid value for option %s. Possible values are: ");
            for (int index = 0; index < this.getChoices().size(); ++index) {
                builder.append(this.getChoices().get(index).toLowerCase());
                if (this.getChoices().size() > 1 && index == this.getChoices().size() - 2) {
                    builder.append(" or ");
                    continue;
                }
                if (index == this.getChoices().size() - 1) continue;
                builder.append(", ");
            }
            throw new OptionException(String.format(builder.toString(), valueAsString, this.getKey()));
        }
    }

    @Override
    public void setFromObject(Object valueAsObject) throws OptionException {
        if (!(valueAsObject instanceof EnumOption)) {
            throw new OptionException("Error while setting value from object. Expected type is Enum<?>, actual type is " + valueAsObject.getClass().getSimpleName());
        }
        Enum value = (Enum)((EnumOption)valueAsObject).get();
        this.set(value);
    }

    @Override
    public Object getAsObject() {
        return this;
    }
}

