/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.options;

import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.options.converter.BooleanStringConverter;

public class BooleanOption
extends Option<Boolean> {
    public BooleanOption(String key, Boolean defaultValue) throws OptionException {
        super(key, defaultValue, new BooleanStringConverter());
        this.initChoices();
    }

    private void initChoices() {
        this.choices.clear();
        this.choices.add(this.stringConverter.convert(true));
        this.choices.add(this.stringConverter.convert(false));
    }

    @Override
    public void setFromObject(Object valueAsObject) throws OptionException {
        if (!(valueAsObject instanceof BooleanOption)) {
            throw new OptionException("Error while setting value from object. Expected type is Boolean, actual type is " + valueAsObject.getClass().getSimpleName());
        }
        Boolean value = (Boolean)((BooleanOption)valueAsObject).get();
        this.set(value);
    }

    @Override
    public Object getAsObject() {
        return this;
    }
}

