/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.math;

public class MathUtils {
    private static final double DOUBLE_EQUALITY_TOLERANCE = 1.0E-7;

    public static double limitTo(double value, double minValue, double maxValue) {
        return Math.min(maxValue, Math.max(minValue, value));
    }

    public static double normalize(double value, double minValue, double maxValue) {
        return (value - minValue) / (maxValue - minValue);
    }

    public static double limitAndNormalize(double value, double minValue, double maxValue) {
        double limited = MathUtils.limitTo(value, minValue, maxValue);
        return MathUtils.normalize(limited, minValue, maxValue);
    }

    public static boolean equalsWithTolerance(double d1, double d2) {
        return Math.abs(d1 - d2) <= 1.0E-7;
    }

    public static boolean lessOrEqualsWithTolerance(double d1, double d2) {
        return MathUtils.equalsWithTolerance(d1, d2) || d1 < d2;
    }

    public static boolean isIntegerWithTolerance(double d) {
        return MathUtils.equalsWithTolerance(d, Math.round(d));
    }
}

