/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.log;

import at.mrdevelopment.toolkit.log.LogEntry;
import at.mrdevelopment.toolkit.log.LogList;
import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import org.joda.time.DateTime;

public class MemoryLogger
extends AppenderSkeleton {
    private final LogList logList = LogList.getInstance();

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
    }

    public boolean requiresLayout() {
        return true;
    }

    protected synchronized boolean checkEntryConditions() {
        if (this.closed) {
            LogLog.warn((String)"Not allowed to write to a closed appender.");
            return false;
        }
        if (this.layout == null) {
            this.errorHandler.error("No layout set for the appender named [" + this.name + "].");
            return false;
        }
        return true;
    }

    public void setSize(int size) {
        this.logList.setMaxSize(size);
    }

    public void append(LoggingEvent event) {
        if (!this.checkEntryConditions()) {
            return;
        }
        this.subAppend(event);
    }

    protected void subAppend(LoggingEvent event) {
        String loggerName = event.getLoggerName();
        int index = loggerName.lastIndexOf(46);
        if (index > -1) {
            loggerName = loggerName.substring(index + 1);
        }
        DateTime time = new DateTime(event.getTimeStamp());
        LogEntry logEntry = new LogEntry(time, loggerName, (String)event.getMessage(), event.getThreadName(), event.getLevel());
        this.logList.insert(logEntry);
    }

    public static boolean isEnabled() {
        Enumeration allAppenders = Logger.getRootLogger().getAllAppenders();
        while (allAppenders.hasMoreElements()) {
            Appender appender = (Appender)allAppenders.nextElement();
            if (!(appender instanceof MemoryLogger)) continue;
            return true;
        }
        return false;
    }
}

