/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.log;

import at.mrdevelopment.toolkit.log.LogEntry;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LogList {
    private static LogList instance = null;
    private final Queue<LogEntry> logEntries = new ArrayDeque<LogEntry>();
    private int maxSize = 0;

    private LogList() {
    }

    public static LogList getInstance() {
        if (instance == null) {
            instance = new LogList();
        }
        return instance;
    }

    public synchronized void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public synchronized void insert(LogEntry logEntry) {
        if (this.logEntries.size() >= this.maxSize) {
            this.logEntries.poll();
        }
        this.logEntries.add(logEntry);
    }

    public synchronized List<LogEntry> filterByLevel(Level minLevel) {
        ArrayList<LogEntry> filteredList = new ArrayList<LogEntry>();
        for (LogEntry entry : this.logEntries) {
            if (!entry.getLogLevel().isGreaterOrEqual((Priority)minLevel)) continue;
            filteredList.add(entry);
        }
        return filteredList;
    }

    public static Document toXML(List<LogEntry> entryList, XMLToolkit xmlToolkit) {
        Document document = xmlToolkit.newDocument();
        Element root = document.createElement("logs");
        for (LogEntry entry : entryList) {
            Element logElement = document.createElement("log");
            logElement.setAttribute("time", xmlToolkit.formatTime(entry.getTime()));
            logElement.setAttribute("level", entry.getLogLevel().toString());
            logElement.setAttribute("name", entry.getLoggerName());
            logElement.setAttribute("message", entry.getLogMessage());
            root.appendChild(logElement);
        }
        document.appendChild(root);
        return document;
    }
}

