/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.log;

import at.mrdevelopment.toolkit.log.ESLRemoteLogger;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.Socket;
import java.net.SocketException;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggingEvent;

public class ESLSocketNode
implements Runnable {
    Socket socket;
    LoggerRepository hierarchy;
    ObjectInputStream ois;
    static Logger logger = Logger.getLogger(ESLSocketNode.class);

    public ESLSocketNode(Socket socket, LoggerRepository hierarchy) {
        this.socket = socket;
        this.hierarchy = hierarchy;
        try {
            this.ois = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
        }
        catch (Exception exc) {
            logger.error((Object)("Could not open ObjectInputStream to " + socket), (Throwable)exc);
        }
    }

    @Override
    public void run() {
        try {
            while (true) {
                LoggingEvent event = (LoggingEvent)this.ois.readObject();
                Logger remoteLogger = this.hierarchy.getLogger(event.getLoggerName());
                if (!event.getLevel().isGreaterOrEqual((Priority)remoteLogger.getEffectiveLevel())) continue;
                remoteLogger.info((Object)("Log from " + this.socket.getLocalAddress().getHostAddress() + ":" + this.socket.getLocalPort()));
                remoteLogger.callAppenders(event);
            }
        }
        catch (EOFException exc) {
            logger.info((Object)"Caught java.io.EOFException closing connection.");
            this.retry(this.socket);
        }
        catch (SocketException exc) {
            logger.info((Object)"Caught java.net.SocketException retrying connection.");
            this.retry(this.socket);
        }
        catch (IOException exc) {
            logger.info((Object)("Caught java.io.IOException: " + exc));
            logger.info((Object)"Closing connection.");
        }
        catch (Exception exc) {
            logger.error((Object)"Unexpected exception. Closing connection.", (Throwable)exc);
        }
        try {
            this.ois.close();
        }
        catch (Exception exc) {
            logger.info((Object)"Could not close connection.", (Throwable)exc);
        }
    }

    private void retry(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException exc) {
                logger.warn((Object)("Error closing socket" + socket.getLocalPort() + " during retry"), (Throwable)exc);
            }
            ESLRemoteLogger.retrySocketNode(socket.getLocalPort());
        }
    }
}

