/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.log;

import at.mrdevelopment.toolkit.log.ESLLogger;

public class ComputationTimeLogger {
    private final ESLLogger logger;
    private long startTime = 0L;

    public ComputationTimeLogger(ESLLogger logger) {
        this.logger = logger;
    }

    public boolean isStarted() {
        return this.startTime != 0L;
    }

    public ComputationTimeLogger start() {
        this.startTime = System.nanoTime();
        return this;
    }

    public void logTime(String message, long minTimeForLogging) {
        long computationTime = (System.nanoTime() - this.startTime) / 1000000L;
        if (computationTime >= minTimeForLogging) {
            this.logger.debug(message + ": %s ms", computationTime);
        }
    }

    public void logTimeInfo(String message) {
        long computationTime = (System.nanoTime() - this.startTime) / 1000000L;
        this.logger.info(message + ": %s ms", computationTime);
    }

    public void logNanosInfo(String message) {
        long computationTime = System.nanoTime() - this.startTime;
        this.logger.info(message + ": %s ns", computationTime);
    }

    public void logTime(String message) {
        this.logTime(message, 0L);
    }

    public void logTimeIfStarted(String message) {
        if (this.isStarted()) {
            this.logTime(message);
        }
    }
}

