/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.integritycheck;

import at.mrdevelopment.toolkit.integritycheck.AbstractResultHandler;
import at.mrdevelopment.toolkit.integritycheck.FileIntegrityResult;
import java.io.PrintStream;

public class PrintStreamResultHandler
extends AbstractResultHandler {
    private final PrintStream printStream;

    public PrintStreamResultHandler(PrintStream printStream) {
        this.printStream = printStream;
    }

    @Override
    public void handleResult(FileIntegrityResult result) {
        super.handleResult(result);
        this.printStream.println(result.toString());
    }

    @Override
    public void finished() {
        this.printStream.format("Validation of %d files finished within %d milliseconds (%d valid, %d failed)%n", this.getTotalFiles(), this.getTimeElapsed(), this.getValidFiles(), this.getFailedFiles());
        this.printStream.format("Validation %s%n", this.getFailedFiles() == 0 ? "SUCCESSFUL" : "FAILED");
    }
}

