/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.integritycheck;

import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.gui.GUIUtils;
import at.mrdevelopment.toolkit.integritycheck.Crc32FileIntegrityEntry;
import at.mrdevelopment.toolkit.integritycheck.FileIntegrityResult;
import at.mrdevelopment.toolkit.integritycheck.PrintStreamResultHandler;
import at.mrdevelopment.toolkit.integritycheck.ResultHandler;
import at.mrdevelopment.toolkit.integritycheck.gui.GuiResultHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class InstallationIntegrityCheck {
    public static void main(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        OptionSpecBuilder optionGenerate = parser.accepts("generate", "Generate validation file");
        OptionSpecBuilder optionValidate = parser.accepts("validate", "Validate installation");
        ArgumentAcceptingOptionSpec optionFile = parser.accepts("file", "Checksum file").withOptionalArg().ofType(File.class).defaultsTo((Object)new File("checksum.txt"), (Object[])new File[0]);
        ArgumentAcceptingOptionSpec optionExcludeFile = parser.accepts("exclude", "Exclude files listed in this file").withOptionalArg().ofType(File.class).defaultsTo((Object)new File("exclude.txt"), (Object[])new File[0]);
        OptionSpecBuilder optionGui = parser.accepts("gui", "Show graphical user interface");
        OptionSpecBuilder optionHelp = parser.accepts("help", "Show this help");
        OptionSet options = parser.parse(args);
        if (options.has((OptionSpec)optionHelp) || !options.has((OptionSpec)optionGenerate) && !options.has((OptionSpec)optionValidate)) {
            parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        File target = (File)options.valueOf((OptionSpec)optionFile);
        File exclude = (File)options.valueOf((OptionSpec)optionExcludeFile);
        boolean generate = options.has((OptionSpec)optionGenerate);
        boolean validate = options.has((OptionSpec)optionValidate);
        boolean showGui = options.has((OptionSpec)optionGui);
        if (generate) {
            InstallationIntegrityCheck.generate(new File("."), target, exclude);
        }
        if (validate) {
            if (showGui) {
                GUIUtils.setSystemLookAndFeel();
                GuiResultHandler resultHandler = new GuiResultHandler();
                InstallationIntegrityCheck.validate(target, resultHandler);
            } else {
                PrintStreamResultHandler resultHandler = new PrintStreamResultHandler(System.out);
                InstallationIntegrityCheck.validate(target, resultHandler);
                System.exit(resultHandler.isFailed() ? 1 : 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generate(File directory, File targetFile, File excludeFile) throws FileNotFoundException, IOException {
        Set<String> excludes = InstallationIntegrityCheck.readExcludesFromFile(excludeFile);
        excludes.add(targetFile.getName());
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(targetFile);
            InstallationIntegrityCheck.generate(directory, writer, excludes);
        }
        catch (Throwable throwable) {
            StreamUtils.close(writer);
            throw throwable;
        }
        StreamUtils.close(writer);
    }

    private static Set<String> readExcludesFromFile(File excludeFile) throws IOException {
        HashSet<String> excludes = new HashSet<String>();
        if (excludeFile != null && excludeFile.exists()) {
            System.out.format("Excluding files listed in %s%n", excludeFile.getPath());
            excludes.addAll(FileUtils.readLines((File)excludeFile));
        } else {
            System.out.format("No files to to exclude%n", new Object[0]);
        }
        return excludes;
    }

    private static void generate(File directory, PrintWriter writer, Set<String> excludes) {
        for (File file : directory.listFiles()) {
            if (InstallationIntegrityCheck.exclude(file, excludes)) {
                System.out.format("Skipping %s%n", file.getPath());
                continue;
            }
            if (file.isFile()) {
                try {
                    Crc32FileIntegrityEntry entry = new Crc32FileIntegrityEntry(file);
                    writer.println(((Object)entry).toString());
                }
                catch (IOException exc) {
                    System.err.println(String.format("%s failed", file.getPath()));
                }
                continue;
            }
            if (!file.isDirectory()) continue;
            InstallationIntegrityCheck.generate(file, writer, excludes);
        }
    }

    private static boolean exclude(File file, Set<String> excludes) {
        return excludes.contains(file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validate(File source, ResultHandler resultHandler) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(source));
            String line = reader.readLine();
            while (line != null) {
                if (!line.trim().isEmpty() && !line.startsWith("#")) {
                    String[] record = StringUtils.splitPreserveAllTokens((String)line, (String)";");
                    if (record.length == 2) {
                        File file = new File(record[1]);
                        String checksum = record[0];
                        if (!file.exists()) {
                            resultHandler.handleResult(FileIntegrityResult.missing(file, checksum));
                        } else {
                            try {
                                Crc32FileIntegrityEntry fileIntegrityEntry = new Crc32FileIntegrityEntry(file);
                                resultHandler.handleResult(FileIntegrityResult.validate(fileIntegrityEntry, checksum));
                            }
                            catch (IOException exc) {
                                resultHandler.handleResult(FileIntegrityResult.ioError(file, checksum));
                            }
                        }
                    } else {
                        System.err.println("Skipping invalid line");
                    }
                }
                line = reader.readLine();
            }
            resultHandler.finished();
        }
        catch (Throwable throwable) {
            StreamUtils.close(reader);
            throw throwable;
        }
        StreamUtils.close(reader);
    }
}

