/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.info;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.RequiredVersion;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.info.InfoXMLSerializer;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Info {
    private static final String INFO_FILENAME = "/info/info.xml";
    private final Version version;
    private final RequiredVersion requiredVersion;

    public Info(Version version, RequiredVersion requiredVersion) {
        this.version = version;
        this.requiredVersion = requiredVersion;
    }

    public Version getVersion() {
        return this.version;
    }

    public RequiredVersion getRequiredVersion() {
        return this.requiredVersion;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Missing argument: Jar file");
            System.exit(1);
        }
        try {
            Info info = Info.loadFromExternalJar(args[0]);
            Version version = info.getVersion();
            System.out.format("%s_%d%n", version, version.getBuild());
            System.exit(0);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            System.exit(1);
        }
    }

    public static Info load(Class<?> type) throws SerializeException, InitializationException {
        InputStream inputStream = type.getResourceAsStream(INFO_FILENAME);
        return new InfoXMLSerializer().parseXML(inputStream);
    }

    public static Info load(InputStream inputStream) throws SerializeException, InitializationException {
        return new InfoXMLSerializer().parseXML(inputStream);
    }

    public static Info loadFromExternalJar(String externalJarLocation) throws IOException, SerializeException, InitializationException {
        String infoFilename;
        URL url = new URL(String.format("jar:file:%s!/", externalJarLocation));
        JarURLConnection urlConnection = (JarURLConnection)url.openConnection();
        JarFile jarFile = urlConnection.getJarFile();
        JarEntry jarEntry = jarFile.getJarEntry(infoFilename = INFO_FILENAME.replaceFirst("/", ""));
        if (jarEntry == null) {
            throw new FileNotFoundException(String.format("No info file (%s) found in jar %s", infoFilename, externalJarLocation));
        }
        return Info.load(jarFile.getInputStream(jarEntry));
    }
}

