/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.image;

import at.mrdevelopment.toolkit.image.ColorMapping;
import at.mrdevelopment.toolkit.image.ImageUtils;
import at.mrdevelopment.toolkit.image.RawImage;
import at.mrdevelopment.toolkit.image.RawImageImpl;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public enum RawImageType {
    TYPE_BINARY{

        @Override
        public RawImage fromBufferedImage(BufferedImage source, ColorMapping[] colorMappings) {
            int width = source.getWidth();
            int height = source.getHeight();
            BufferedImage image = ImageUtils.toBlackWhite(source);
            WritableRaster raster = image.getRaster();
            RawImageImpl target = new RawImageImpl(width, height, this, colorMappings);
            byte[] data = target.getBytes();
            int[] color = new int[3];
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    raster.getPixel(x, y, color);
                    int value = colorMappings[0].getValue(color);
                    if (value <= 0) continue;
                    int index = y * (width / 8) + x / 8;
                    data[index] = (byte)(data[index] | (byte)(1 << 7 - x % 8));
                }
            }
            return target;
        }

        @Override
        public BufferedImage toBufferedImage(RawImage source, ColorMapping[] colorMappings) {
            int width = source.getWidth();
            int height = source.getHeight();
            byte[] data = source.getBytes();
            BufferedImage target = new BufferedImage(width, height, 1);
            WritableRaster raster = target.getRaster();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int value = (byte)(data[y * (width / 8) + x / 8] >> 7 - x % 8) & 1;
                    int[] color = colorMappings[0].getColor(value);
                    raster.setPixel(x, y, color);
                }
            }
            return target;
        }

        @Override
        public int getImageSize(int width, int height) {
            return width * height / 8;
        }
    }
    ,
    TYPE_2BIT{

        @Override
        public RawImage fromBufferedImage(BufferedImage source, ColorMapping[] colorMappings) {
            int width = source.getWidth();
            int height = source.getHeight();
            WritableRaster raster = source.getRaster();
            RawImageImpl target = new RawImageImpl(width, height, this, colorMappings);
            byte[] data = target.getBytes();
            int[] color = new int[3];
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    raster.getPixel(x, y, color);
                    int value = colorMappings[0].getValue(color) & 3;
                    int index = y * (width / 4) + x / 4;
                    data[index] = (byte)(data[index] | (byte)(value << 6 - x % 4 * 2));
                }
            }
            return target;
        }

        @Override
        public BufferedImage toBufferedImage(RawImage source, ColorMapping[] colorMappings) {
            int width = source.getWidth();
            int height = source.getHeight();
            byte[] data = source.getBytes();
            BufferedImage target = new BufferedImage(width, height, 1);
            WritableRaster raster = target.getRaster();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int value = (byte)(data[y * (width / 4) + x / 4] >> 6 - x % 4 * 2) & 3;
                    int[] color = colorMappings[0].getColor(value);
                    raster.setPixel(x, y, color);
                }
            }
            return target;
        }

        @Override
        public int getImageSize(int width, int height) {
            return width * height / 4;
        }
    }
    ,
    LINED_UP_IMAGES{

        @Override
        public RawImage fromBufferedImage(BufferedImage source, ColorMapping[] colorMappings) {
            int width = source.getWidth();
            int height = source.getHeight();
            RawImageImpl target = new RawImageImpl(width, height, this, colorMappings);
            BufferedImage blackWhiteImage = this.extractImage(source, colorMappings[0]);
            BufferedImage redWhiteImage = this.extractImage(source, colorMappings[1]);
            int offset = width * height / 8;
            this.writeRawImagePart(target, 0, blackWhiteImage, colorMappings[0]);
            this.writeRawImagePart(target, offset, redWhiteImage, colorMappings[1]);
            return target;
        }

        private BufferedImage extractImage(BufferedImage image, ColorMapping colorMapping) {
            int width = image.getWidth();
            int height = image.getHeight();
            BufferedImage target = new BufferedImage(width, height, 1);
            WritableRaster imageRaster = image.getRaster();
            WritableRaster targetRaster = target.getRaster();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int[] color = imageRaster.getPixel(x, y, (int[])null);
                    int value = colorMapping.getValue(color);
                    targetRaster.setPixel(x, y, colorMapping.getColor(value));
                }
            }
            return target;
        }

        private void writeRawImagePart(RawImage target, int offset, BufferedImage image, ColorMapping colorMapping) {
            int width = image.getWidth();
            int height = image.getHeight();
            WritableRaster raster = image.getRaster();
            byte[] data = target.getBytes();
            int[] color = new int[3];
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    raster.getPixel(x, y, color);
                    int value = colorMapping.getValue(color);
                    if (value <= 0) continue;
                    int index = offset + y * (width / 8) + x / 8;
                    data[index] = (byte)(data[index] | (byte)(1 << 7 - x % 8));
                }
            }
        }

        @Override
        public BufferedImage toBufferedImage(RawImage source, ColorMapping[] colorMappings) {
            int width = source.getWidth();
            int height = source.getHeight();
            byte[] data = source.getBytes();
            BufferedImage blackWhiteImage = new BufferedImage(width, height, 2);
            BufferedImage redWhiteImage = new BufferedImage(width, height, 2);
            int offset = width * height / 8;
            this.writeBufferedImagePart(blackWhiteImage, 0, data, colorMappings[0]);
            this.writeBufferedImagePart(redWhiteImage, offset, data, colorMappings[1]);
            BufferedImage target = new BufferedImage(width, height, 2);
            ImageUtils.fill(target, Color.WHITE);
            ImageUtils.overlay(target, blackWhiteImage);
            ImageUtils.overlay(target, redWhiteImage);
            return target;
        }

        private void writeBufferedImagePart(BufferedImage image, int offset, byte[] data, ColorMapping colorMapping) {
            int width = image.getWidth();
            int height = image.getHeight();
            WritableRaster raster = image.getRaster();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int value = (byte)(data[offset + y * (width / 8) + x / 8] >> 7 - x % 8) & 1;
                    int[] color = colorMapping.getColor(value);
                    raster.setPixel(x, y, color);
                }
            }
        }

        @Override
        public int getImageSize(int width, int height) {
            return width * height / 4;
        }
    };


    public abstract RawImage fromBufferedImage(BufferedImage var1, ColorMapping[] var2);

    public abstract BufferedImage toBufferedImage(RawImage var1, ColorMapping[] var2);

    public abstract int getImageSize(int var1, int var2);
}

