/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.image;

import at.mrdevelopment.toolkit.image.ColorMapping;
import at.mrdevelopment.toolkit.image.ImageSerializer;
import at.mrdevelopment.toolkit.image.RawImage;
import at.mrdevelopment.toolkit.image.RawImageImpl;
import at.mrdevelopment.toolkit.image.RawImageType;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.awt.image.BufferedImage;

public class RawImageFactory {
    public static RawImage newImage(int width, int height, RawImageType type, ColorMapping ... colorMappings) {
        return new RawImageImpl(width, height, type, colorMappings);
    }

    public static RawImage newImage(BufferedImage bufferedImage, RawImageType type, ColorMapping ... colorMappings) {
        return type.fromBufferedImage(bufferedImage, colorMappings);
    }

    public static RawImage newImage(String encodedImage, RawImageType type, ColorMapping ... colorMappings) throws SerializeException {
        return type.fromBufferedImage(ImageSerializer.fromBase64String(encodedImage), colorMappings);
    }

    public static RawImage newImage(int width, int height, byte[] data, RawImageType type, ColorMapping ... colorMappings) {
        return new RawImageImpl(width, height, data, type, colorMappings);
    }
}

