/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.image;

import at.mrdevelopment.toolkit.image.HorizontalAlignment;
import at.mrdevelopment.toolkit.image.RoundedRectangle;
import at.mrdevelopment.toolkit.image.ShadowProperties;
import at.mrdevelopment.toolkit.image.VerticalAlignment;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.jhlabs.image.GaussianFilter;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.LookupOp;
import java.awt.image.PixelGrabber;
import java.awt.image.ShortLookupTable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.LinkedList;
import javax.imageio.ImageIO;

public class ImageUtils {
    static ESLLogger logger = ESLLogger.getLogger(ImageUtils.class);
    private static final int MAXVAL = 0xFFFFFF;
    private static final int MINVAL = 0;
    private static final int WHITE = 1;
    private static final Stroke DEFAULT_DASHED_STROKE = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{4.0f}, 10.0f);
    private static short[] invertTable;

    private ImageUtils() {
    }

    public static BufferedImage byteMatrixToImage(ByteMatrix byteMatrix) {
        BufferedImage image = new BufferedImage(byteMatrix.getWidth(), byteMatrix.getHeight(), 12);
        int x = 0;
        for (byte[] matrixline : byteMatrix.getArray()) {
            int y = 0;
            for (byte elem : matrixline) {
                image.setRGB(y, x, elem == 1 ? 0 : 0xFFFFFF);
                ++y;
            }
            ++x;
        }
        return image;
    }

    public static BufferedImage resize(BufferedImage originalImage, int requestedWidth, int requestedHeight) {
        if (originalImage == null) {
            throw new IllegalArgumentException("Image was null");
        }
        return ImageUtils.resize(originalImage, requestedWidth, requestedHeight, originalImage.getType());
    }

    public static BufferedImage resize(BufferedImage originalImage, int requestedWidth, int requestedHeight, int imageType) {
        if (originalImage == null) {
            throw new IllegalArgumentException("Image was null");
        }
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        BufferedImage resizedImage = new BufferedImage(requestedWidth, requestedHeight, imageType);
        Graphics2D graphics = resizedImage.createGraphics();
        graphics.drawImage(originalImage, 0, 0, requestedWidth, requestedHeight, 0, 0, width, height, null);
        graphics.dispose();
        return resizedImage;
    }

    public static BufferedImage scale(BufferedImage originalImage, int scale, int imageType) throws IllegalArgumentException {
        if (originalImage == null) {
            throw new IllegalArgumentException("Image was null");
        }
        if (scale < 1) {
            throw new IllegalArgumentException("Scale must be at least 1");
        }
        return ImageUtils.resize(originalImage, originalImage.getWidth() * scale, originalImage.getHeight() * scale);
    }

    public static BufferedImage scale(BufferedImage originalImage, int scale) throws IllegalArgumentException {
        if (originalImage == null) {
            throw new IllegalArgumentException("Image was null");
        }
        return ImageUtils.scale(originalImage, scale, originalImage.getType());
    }

    public static BufferedImage clip(BufferedImage originalImage, Rectangle rectangle) {
        if (originalImage == null) {
            return null;
        }
        int imageType = 1;
        if (originalImage.getType() != 0) {
            imageType = originalImage.getType();
        }
        return ImageUtils.clip(originalImage, rectangle, imageType);
    }

    public static BufferedImage clip(BufferedImage originalImage, Rectangle rectangle, int imageType) {
        if (rectangle == null || originalImage == null) {
            return null;
        }
        int width = (int)rectangle.getWidth();
        int height = (int)rectangle.getHeight();
        int xsrc = (int)rectangle.getMinX();
        int ysrc = (int)rectangle.getMinY();
        BufferedImage clippedImage = new BufferedImage(width, height, imageType);
        Graphics2D graphics = clippedImage.createGraphics();
        graphics.drawImage(originalImage, 0, 0, width, height, xsrc, ysrc, xsrc + width, ysrc + height, null);
        graphics.dispose();
        return clippedImage;
    }

    public static BufferedImage clipToUsedSize(BufferedImage image, Rectangle contentBounds, int maxWidth, int maxHeight) {
        if (contentBounds != null) {
            int width = contentBounds.width > maxWidth ? maxWidth : contentBounds.width;
            int height = contentBounds.height > maxHeight ? maxHeight : contentBounds.height;
            return ImageUtils.clip(image, new Rectangle(contentBounds.x, contentBounds.y, width, height));
        }
        return image;
    }

    public static void overlay(BufferedImage background, BufferedImage foreground) throws IllegalArgumentException {
        ImageUtils.overlay(background, foreground, 0, 0, background.getWidth(), background.getHeight(), 0, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
    }

    public static void overlayAt(BufferedImage background, BufferedImage foreground, int posX, int posY) throws IllegalArgumentException {
        if (background == null || background.getWidth() <= 0 || background.getHeight() <= 0 || foreground == null || foreground.getWidth() <= 0 || foreground.getHeight() <= 0) {
            throw new IllegalArgumentException("Foreground and background image cannot be empty.");
        }
        if (background.getWidth() < posX + foreground.getWidth() || background.getHeight() < posY + foreground.getHeight()) {
            throw new IllegalArgumentException("Background image is too small");
        }
        Graphics2D graphics = background.createGraphics();
        graphics.drawImage((Image)foreground, posX, posY, null);
    }

    public static void overlayTopLeft(BufferedImage background, BufferedImage foreground) throws IllegalArgumentException {
        ImageUtils.overlay(background, foreground, 0, 0, background.getWidth(), background.getHeight(), 0, HorizontalAlignment.LEFT, VerticalAlignment.TOP);
    }

    public static Point overlay(BufferedImage background, Rectangle clippingRegion, BufferedImage foreground, Rectangle alignmentBounds, int posX, int posY, int width, int height, int rotation, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) throws IllegalArgumentException {
        if (background.getWidth() < posX + width || background.getHeight() < posY + height) {
            throw new IllegalArgumentException("Background image is too small");
        }
        if (width < alignmentBounds.width || height < alignmentBounds.height) {
            throw new IllegalArgumentException("Drawing area is too small");
        }
        if (horizontalAlignment == HorizontalAlignment.CENTER) {
            posX += ImageUtils.getCenteringIndex(width, alignmentBounds.width);
        } else if (horizontalAlignment == HorizontalAlignment.RIGHT) {
            posX = posX + width - alignmentBounds.width;
        }
        if (verticalAlignment == VerticalAlignment.CENTER) {
            posY += ImageUtils.getCenteringIndex(height, alignmentBounds.height);
        } else if (verticalAlignment == VerticalAlignment.BOTTOM) {
            posY = posY + height - alignmentBounds.height;
        }
        Graphics2D graphics = background.createGraphics();
        if (clippingRegion != null) {
            graphics.setClip(clippingRegion);
        }
        graphics.drawImage((Image)foreground, posX, posY, null);
        return new Point(posX, posY);
    }

    public static Point overlay(BufferedImage background, Rectangle clippingRegion, BufferedImage foreground, int posX, int posY, int width, int height, int rotation, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) throws IllegalArgumentException {
        return ImageUtils.overlay(background, clippingRegion, foreground, new Rectangle(foreground.getWidth(), foreground.getHeight()), posX, posY, width, height, rotation, horizontalAlignment, verticalAlignment);
    }

    public static Point overlay(BufferedImage background, BufferedImage foreground, int posX, int posY, int width, int height, int rotation, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) throws IllegalArgumentException {
        return ImageUtils.overlay(background, null, foreground, new Rectangle(foreground.getWidth(), foreground.getHeight()), posX, posY, width, height, rotation, horizontalAlignment, verticalAlignment);
    }

    public static int getCenteringIndex(int framePx, int contentPx) {
        return (int)Math.floor((double)(framePx - contentPx) / 2.0);
    }

    public static void fill(BufferedImage image, Color color) {
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(color);
        graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        graphics.dispose();
    }

    public static BufferedImage createImage(int width, int height, int type, Color color) {
        BufferedImage image = new BufferedImage(width, height, type);
        ImageUtils.fill(image, color);
        return image;
    }

    public static BufferedImage createImage(int width, int height, int type) {
        return new BufferedImage(width, height, type);
    }

    public static BufferedImage flip(BufferedImage image) {
        AffineTransform tx = AffineTransform.getScaleInstance(-1.0, -1.0);
        tx.translate(-image.getWidth(null), -image.getHeight(null));
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        return op.filter(image, null);
    }

    public static BufferedImage toBlackWhite(BufferedImage image) {
        BufferedImage blackAndWhiteImage = new BufferedImage(image.getWidth(), image.getHeight(), 12);
        Graphics2D graphics = blackAndWhiteImage.createGraphics();
        graphics.drawImage((Image)image, 0, 0, null);
        graphics.dispose();
        return blackAndWhiteImage;
    }

    public static BufferedImage toRGB(BufferedImage image) {
        BufferedImage rgbImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        Graphics2D graphics = rgbImage.createGraphics();
        graphics.drawImage((Image)image, 0, 0, null);
        graphics.dispose();
        return rgbImage;
    }

    public static void drawBorder(BufferedImage fieldImage, RoundedRectangle rectangle, Color borderColor, Stroke borderStroke) {
        ImageUtils.drawBorder(fieldImage, 0, 0, rectangle, borderColor, borderStroke);
    }

    public static void drawBorder(BufferedImage fieldImage, int x, int y, RoundedRectangle rectangle, Color borderColor, Stroke borderStroke) {
        Graphics2D graphics = fieldImage.createGraphics();
        ImageUtils.drawBorder(graphics, x, y, rectangle, borderColor, borderStroke);
        graphics.dispose();
    }

    public static void drawBorder(Graphics2D graphics, int x, int y, RoundedRectangle rectangle, Color borderColor, Stroke borderStroke) {
        graphics.setColor(borderColor);
        graphics.setStroke(borderStroke);
        float width = rectangle.getWidth();
        float height = rectangle.getHeight();
        graphics.draw(new RoundedRectangle(x, y, width, height, rectangle.getCornerRadius(), rectangle.getCornerFlags()).getShape());
    }

    public static void drawBorder(BufferedImage image, Color color, BasicStroke stroke, boolean rounded) {
        int width = image.getWidth();
        int height = image.getHeight();
        int thickness = Math.round(stroke.getLineWidth());
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(color);
        for (int i = 0; i < thickness; ++i) {
            if (rounded) {
                graphics.drawRoundRect(i, i, width - i - i - 1, height - i - i - 1, thickness, thickness);
                continue;
            }
            graphics.drawRect(i, i, width - i - i - 1, height - i - i - 1);
        }
    }

    public static void drawBorder(BufferedImage image, int posX, int posY, int width, int height, Color color, Stroke stroke) {
        ImageUtils.drawBorder(image, (Shape)new Rectangle(posX, posY, width, height), color, stroke);
    }

    public static void drawBorder(BufferedImage image, Shape shape, Color color, Stroke stroke) {
        Graphics2D graphics = image.createGraphics();
        ImageUtils.drawBorder(graphics, shape, color, stroke);
        graphics.dispose();
    }

    public static void drawBorder(Graphics2D graphics, Shape shape, Color color, Stroke stroke) {
        graphics.setColor(color);
        graphics.setStroke(stroke);
        graphics.draw(shape);
    }

    public static void drawBorderLine(BufferedImage image, int x1, int y1, int x2, int y2, Color color, int thickness, Stroke stroke) throws IllegalArgumentException {
        if (x1 != x2 && y1 != y2) {
            throw new IllegalArgumentException("Border can only be drawn horizontal or vertical.");
        }
        if (x1 == x2) {
            x1 += thickness / 2;
            x2 += thickness / 2;
        } else {
            y1 += thickness / 2;
            y2 += thickness / 2;
        }
        Graphics2D graphics = image.createGraphics();
        graphics.setStroke(stroke);
        graphics.setColor(color);
        graphics.drawLine(x1, y1, x2, y2);
        graphics.dispose();
    }

    public static void drawContinuousBorderLine(BufferedImage image, int x1, int y1, int x2, int y2, Color color, int thickness) throws IllegalArgumentException {
        ImageUtils.drawBorderLine(image, x1, y1, x2, y2, color, thickness, new BasicStroke(thickness));
    }

    public static void drawDottedBorderLine(BufferedImage image, int x1, int y1, int x2, int y2, Color color, int thickness) throws IllegalArgumentException {
        ImageUtils.drawBorderLine(image, x1, y1, x2, y2, color, thickness, new BasicStroke(thickness, 0, 2, 0.0f, new float[]{4.0f}, 10.0f));
    }

    public static void drawBorder(BufferedImage image, int posX, int posY, int width, int height, Color color) {
        ImageUtils.drawBorder(image, posX, posY, width, height, color, DEFAULT_DASHED_STROKE);
    }

    public static BufferedImage rotate(BufferedImage image, int rotation) {
        BufferedImage newImage = image;
        for (int i = 0; i < rotation; i += 90) {
            newImage = ImageUtils.rotate90Degrees(newImage);
        }
        return newImage;
    }

    public static void drawLine(BufferedImage image, int posXStart, int posYStart, int posXEnd, int posYEnd, int thickness, Color color) {
        Graphics2D graphics = image.createGraphics();
        GeneralPath path = new GeneralPath();
        path.moveTo(posXStart, posYStart);
        path.lineTo(posXEnd, posYEnd);
        path.closePath();
        graphics.setStroke(new BasicStroke(thickness));
        graphics.setPaint(color);
        graphics.draw(path);
        graphics.dispose();
    }

    public static BufferedImage rotate90Degrees(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage newImage = new BufferedImage(height, width, image.getType());
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                newImage.setRGB(height - 1 - j, i, image.getRGB(i, j));
            }
        }
        return newImage;
    }

    public static Rectangle rotate(int rotation, Rectangle bounds, int imageHeight, int imageWidth) {
        Rectangle newBounds = bounds;
        for (int index = 0; index < rotation; index += 90) {
            int height = imageHeight;
            if (index == 90) {
                height = imageWidth;
            }
            newBounds = ImageUtils.rotate90Degrees(rotation, newBounds, height);
        }
        return newBounds;
    }

    private static Rectangle rotate90Degrees(int rotation, Rectangle bounds, int imageHeight) {
        int x = bounds.x;
        int y = bounds.y;
        int height = bounds.height;
        int width = bounds.width;
        return new Rectangle(imageHeight - height - y, x, height, width);
    }

    public static void fillRect(BufferedImage image, Rectangle clippingRegion, int posX, int posY, int width, int height, Color color) throws IllegalArgumentException {
        if (image.getWidth() < posX + width || image.getHeight() < posY + height) {
            throw new IllegalArgumentException("Image is too small");
        }
        Graphics2D graphics = image.createGraphics();
        if (clippingRegion != null) {
            graphics.setClip(clippingRegion);
        }
        graphics.setColor(color);
        graphics.fillRect(posX, posY, width, height);
        graphics.dispose();
    }

    public static void fillRect(BufferedImage image, int posX, int posY, int width, int height, Color color) throws IllegalArgumentException {
        ImageUtils.fillRect(image, null, posX, posY, width, height, color);
    }

    public static BufferedImage clinch(BufferedImage image, int width, int height) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        double scaleX = (double)width / (double)imageWidth;
        double scaleY = (double)height / (double)imageHeight;
        AffineTransform scaleTransform = AffineTransform.getScaleInstance(scaleX, scaleY);
        AffineTransformOp bilinearScaleOp = new AffineTransformOp(scaleTransform, 2);
        return bilinearScaleOp.filter(image, new BufferedImage(width, height, image.getType()));
    }

    public static void drawRect(BufferedImage image, Rectangle rectangle, Color color) {
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(color);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.dispose();
    }

    public static BufferedImage scaleToFit(BufferedImage image, int width, int height) {
        return ImageUtils.scaleToFit(image, new Rectangle(width, height));
    }

    public static BufferedImage scaleToFit(BufferedImage image, Rectangle boundary) {
        double backgroundRatio = (double)boundary.height / (double)boundary.width;
        double imageRatio = (double)image.getHeight() / (double)image.getWidth();
        double scale = 0.0;
        if (backgroundRatio > imageRatio) {
            scale = (double)boundary.width / (double)image.getWidth();
        } else if (backgroundRatio < imageRatio) {
            scale = (double)boundary.height / (double)image.getHeight();
        }
        if (scale != 0.0) {
            BufferedImage backgroundImage = ImageUtils.createImage(boundary.width, boundary.height, 2);
            Graphics2D graphics = backgroundImage.createGraphics();
            graphics.drawImage(image, boundary.x, boundary.y, (int)((double)image.getWidth() * scale), (int)((double)image.getHeight() * scale), null);
            graphics.dispose();
            return backgroundImage;
        }
        return image;
    }

    public static BufferedImage invert(BufferedImage image) {
        if (invertTable == null) {
            invertTable = new short[256];
            for (int i = 0; i < 256; ++i) {
                ImageUtils.invertTable[i] = (short)(255 - i);
            }
        }
        int w = image.getWidth();
        int h = image.getHeight();
        BufferedImage inverted = new BufferedImage(w, h, image.getType());
        LookupOp invertOp = new LookupOp(new ShortLookupTable(0, invertTable), null);
        return invertOp.filter(image, inverted);
    }

    public static BufferedImage rotateImage(BufferedImage img, double degree) {
        return ImageUtils.rotateImage(img, degree, null, null, null, null, 0, 0);
    }

    public static BufferedImage rotateImage(BufferedImage img, double degree, Color backgroundColor, Color borderColor, Stroke borderStroke, RoundedRectangle roundedRectangle, int borderX, int borderY) {
        double angle = Math.toRadians(degree);
        return ImageUtils.tilt(img, angle, backgroundColor, borderColor, borderStroke, roundedRectangle, borderX, borderY);
    }

    public static BufferedImage tilt(BufferedImage image, double angle, Color backgroundColor, Color borderColor, Stroke borderStroke, RoundedRectangle roundedRectangle, int borderX, int borderY) {
        double sin = Math.abs(Math.sin(angle));
        double cos = Math.abs(Math.cos(angle));
        int w = image.getWidth();
        int h = image.getHeight();
        int neww = (int)Math.floor((double)w * cos + (double)h * sin);
        int newh = (int)Math.floor((double)h * cos + (double)w * sin);
        BufferedImage result = new BufferedImage(neww, newh, 2);
        ImageUtils.fill(result, backgroundColor);
        Graphics2D g = result.createGraphics();
        g.translate((neww - w) / 2, (newh - h) / 2);
        g.rotate(angle, w / 2, h / 2);
        g.drawRenderedImage(image, null);
        if (borderColor != null && borderStroke != null) {
            if (roundedRectangle != null) {
                ImageUtils.drawBorder(g, borderX, borderY, roundedRectangle, borderColor, borderStroke);
            } else {
                int width = image.getWidth();
                int height = image.getHeight();
                double degrees = Math.toDegrees(angle);
                if (height % 2 == 0) {
                    if (degrees == 180.0 && borderX == 0 && borderY == 0) {
                        borderX = 1;
                        borderY = 1;
                    } else if (degrees == 90.0 && borderX == 0 && borderY == 0) {
                        borderY = 1;
                    } else if (degrees == 270.0 && borderX == 0 && borderY == 0) {
                        borderX = 1;
                    }
                }
                ImageUtils.drawBorder(g, (Shape)new Rectangle(borderX, borderY, width - 1, height - 1), borderColor, borderStroke);
            }
        }
        g.dispose();
        return result;
    }

    public static Rectangle rotateRectangle(Rectangle rectangle, double degree) {
        Rectangle2D rotatedRectangle = ImageUtils.rotateRectanglePrecisely(rectangle, degree);
        int neww = (int)Math.floor(rotatedRectangle.getWidth());
        int newh = (int)Math.floor(rotatedRectangle.getHeight());
        return new Rectangle(neww, newh);
    }

    public static Rectangle2D rotateRectanglePrecisely(Rectangle rectangle, double degree) {
        double angle = Math.toRadians(degree);
        double sin = Math.abs(Math.sin(angle));
        double cos = Math.abs(Math.cos(angle));
        int w = rectangle.width;
        int h = rectangle.height;
        return new Rectangle2D.Double(0.0, 0.0, (double)w * cos + (double)h * sin, (double)h * cos + (double)w * sin);
    }

    public static Rectangle revertRotation(Rectangle2D rectangle, double degree) {
        double angle = Math.toRadians(-degree);
        double sin = Math.abs(Math.sin(angle));
        double cos = Math.abs(Math.cos(angle));
        double width = rectangle.getWidth();
        double height = rectangle.getHeight();
        double neww = 1.0 / (Math.pow(cos, 2.0) - Math.pow(sin, 2.0)) * (width * cos - height * sin);
        double newh = 1.0 / (Math.pow(cos, 2.0) - Math.pow(sin, 2.0)) * (-width * sin + height * cos);
        return new Rectangle((int)Math.round(neww), (int)Math.round(newh));
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    public static int convertToPixels(float millimeter, int dpi) {
        return Math.round(millimeter * (float)dpi / 25.4f);
    }

    public static BufferedImage loadImageSource(File workingDirectory, String imageSource) throws IOException, IllegalArgumentException {
        URI sourceURI;
        try {
            sourceURI = URI.create(URLEncoder.encode(imageSource, "UTF-8"));
        }
        catch (IllegalArgumentException exc) {
            throw new IllegalArgumentException(String.format("Could not create URI from image source (%s)", imageSource), exc);
        }
        if (sourceURI.getScheme() == null || sourceURI.getScheme().equals("file")) {
            sourceURI = new File(workingDirectory, imageSource).toURI();
        }
        return ImageIO.read(sourceURI.toURL().openStream());
    }

    public static LinkedList<Rectangle> combineAndAlignImages(LinkedList<BufferedImage> imagesToAlign, BufferedImage background, VerticalAlignment verticalAlignment, HorizontalAlignment horizontalAlignment, int rotation) throws IllegalArgumentException {
        if (imagesToAlign == null || imagesToAlign.size() == 0) {
            throw new IllegalArgumentException("No images to align vertically");
        }
        LinkedList<Rectangle> bounds = new LinkedList<Rectangle>();
        int width = 0;
        int height = 0;
        for (BufferedImage imageToAlign : imagesToAlign) {
            height += imageToAlign.getHeight();
            width = Math.max(width, imageToAlign.getWidth());
        }
        if (width > background.getWidth() || height > background.getHeight()) {
            throw new IllegalArgumentException("Background image is too small");
        }
        BufferedImage image = new BufferedImage(width, height, background.getType());
        Graphics2D graphics = image.createGraphics();
        int yPos = 0;
        for (BufferedImage imageToAlign : imagesToAlign) {
            int xPos = 0;
            if (horizontalAlignment == HorizontalAlignment.CENTER) {
                xPos += ImageUtils.getCenteringIndex(width, imageToAlign.getWidth());
            } else if (horizontalAlignment == HorizontalAlignment.RIGHT) {
                xPos = xPos + width - imageToAlign.getWidth();
            }
            graphics.drawImage((Image)imageToAlign, xPos, yPos, null);
            bounds.add(new Rectangle(xPos, yPos, imageToAlign.getWidth(), imageToAlign.getHeight()));
            yPos += imageToAlign.getHeight();
        }
        graphics.dispose();
        Point point = ImageUtils.overlay(background, null, image, new Rectangle(image.getWidth(), image.getHeight()), 0, 0, background.getWidth(), background.getHeight(), rotation, horizontalAlignment, verticalAlignment);
        for (Rectangle rectangle : bounds) {
            rectangle.x += point.x;
            rectangle.y += point.y;
        }
        return bounds;
    }

    private static void applyQualityRenderingHints(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
    }

    public static BufferedImage createCompatibleImage(int width, int height) {
        return ImageUtils.createCompatibleImage(width, height, 3);
    }

    public static BufferedImage createCompatibleImage(int width, int height, int transparency) {
        BufferedImage image = ImageUtils.getGraphicsConfiguration().createCompatibleImage(width, height, transparency);
        image.coerceData(true);
        return image;
    }

    public static BufferedImage createCompatibleImage(BufferedImage image) {
        return ImageUtils.createCompatibleImage(image, image.getWidth(), image.getHeight());
    }

    public static BufferedImage createCompatibleImage(BufferedImage image, int width, int height) {
        return ImageUtils.getGraphicsConfiguration().createCompatibleImage(width, height, image.getTransparency());
    }

    public static GraphicsConfiguration getGraphicsConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    private static BufferedImage generateBlur(BufferedImage imgSource, int size, Color color, double alpha, boolean blur) {
        GaussianFilter filter = new GaussianFilter((float)size);
        int imgWidth = imgSource.getWidth();
        int imgHeight = imgSource.getHeight();
        BufferedImage imgBlur = ImageUtils.createCompatibleImage(imgWidth, imgHeight);
        Graphics2D g2 = imgBlur.createGraphics();
        ImageUtils.applyQualityRenderingHints(g2);
        g2.drawImage((Image)imgSource, 0, 0, null);
        g2.setComposite(AlphaComposite.getInstance(5, (float)alpha));
        g2.setColor(color);
        g2.fillRect(0, 0, imgSource.getWidth(), imgSource.getHeight());
        g2.dispose();
        return blur ? filter.filter(imgBlur, null) : imgBlur;
    }

    public static BufferedImage applyShadow(BufferedImage imgSource, ShadowProperties properties) {
        return ImageUtils.applyShadow(imgSource, properties.getSize(), properties.getColor(), properties.getAlpha(), properties.isBlur());
    }

    public static BufferedImage applyShadow(BufferedImage imgSource, int size, Color color, double alpha, boolean blur) {
        BufferedImage result = ImageUtils.createCompatibleImage(imgSource, imgSource.getWidth() + size * 2, imgSource.getHeight() + size * 2);
        Graphics2D g2d = result.createGraphics();
        g2d.drawImage((Image)ImageUtils.generateShadow(imgSource, size, color, alpha, blur), size, size, null);
        g2d.drawImage((Image)imgSource, 0, 0, null);
        g2d.dispose();
        return result;
    }

    private static BufferedImage generateShadow(BufferedImage imgSource, int size, Color color, double alpha, boolean blur) {
        int imgWidth = imgSource.getWidth() + size * 2;
        int imgHeight = imgSource.getHeight() + size * 2;
        BufferedImage imgMask = ImageUtils.createCompatibleImage(imgWidth, imgHeight);
        Graphics2D g2 = imgMask.createGraphics();
        ImageUtils.applyQualityRenderingHints(g2);
        int x = Math.round((float)(imgWidth - imgSource.getWidth()) / 2.0f);
        int y = Math.round((float)(imgHeight - imgSource.getHeight()) / 2.0f);
        g2.drawImage((Image)imgSource, x, y, null);
        g2.dispose();
        BufferedImage imgGlow = ImageUtils.generateBlur(imgMask, size * 2, color, alpha, blur);
        return imgGlow;
    }

    public static BufferedImage ditherImage(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[][] red = new int[width][height];
        int[][] grn = new int[width][height];
        int[][] blu = new int[width][height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                red[x][y] = image.getRGB(x, y) >> 16 & 0xFF;
                grn[x][y] = image.getRGB(x, y) >> 8 & 0xFF;
                blu[x][y] = image.getRGB(x, y) & 0xFF;
            }
        }
        int[][] pixel_red = ImageUtils.dither(red, height, width);
        int[][] pixel_grn = ImageUtils.dither(grn, height, width);
        int[][] pixel_blu = ImageUtils.dither(blu, height, width);
        BufferedImage img = ImageUtils.createImage(width, height, 1);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pixel = pixel_red[x][y] << 16 | pixel_grn[x][y] << 8 | pixel_blu[x][y];
                img.setRGB(x, y, pixel);
            }
        }
        BufferedImage result = ImageUtils.createImage(width, height, image.getType());
        Graphics2D graphics = result.createGraphics();
        graphics.drawImage((Image)img, 0, 0, null);
        graphics.dispose();
        return result;
    }

    private static int[][] dither(int[][] pixel, int height, int width) {
        for (int y = 0; y < height; ++y) {
            boolean nbottom = y < height - 1;
            for (int x = 0; x < width; ++x) {
                int newpixel;
                boolean nleft = x > 0;
                boolean nright = x < width - 1;
                int oldpixel = pixel[x][y];
                pixel[x][y] = newpixel = oldpixel < 128 ? 0 : 255;
                int error = oldpixel - newpixel;
                if (nright) {
                    int[] nArray = pixel[x + 1];
                    int n = y;
                    nArray[n] = nArray[n] + 7 * error / 16;
                }
                if (nleft & nbottom) {
                    int[] nArray = pixel[x - 1];
                    int n = y + 1;
                    nArray[n] = nArray[n] + 3 * error / 16;
                }
                if (nbottom) {
                    int[] nArray = pixel[x];
                    int n = y + 1;
                    nArray[n] = nArray[n] + 5 * error / 16;
                }
                if (!nright || !nbottom) continue;
                int[] nArray = pixel[x + 1];
                int n = y + 1;
                nArray[n] = nArray[n] + error / 16;
            }
        }
        return pixel;
    }
}

