/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.image;

import at.mrdevelopment.toolkit.image.ImageSerializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;

public class ImageSerializer {
    static ESLLogger logger = ESLLogger.getLogger(ImageSerializer.class);

    public static BufferedImage readImage(File imageFile) throws SerializeException {
        try {
            BufferedImage image = ImageIO.read(imageFile);
            ImageSerializer.checkImage(image);
            return image;
        }
        catch (IOException exc) {
            throw new ImageSerializationException(exc, "Failed to read image from '%s'", imageFile.getPath());
        }
        catch (RuntimeException exc) {
            throw new ImageSerializationException(exc, "Failed to read image from '%s'", imageFile.getPath());
        }
    }

    public static BufferedImage readImage(InputStream inputStream) throws SerializeException {
        try {
            BufferedImage image = ImageIO.read(inputStream);
            ImageSerializer.checkImage(image);
            return image;
        }
        catch (IOException exc) {
            throw new ImageSerializationException(exc, "Failed to read image", new Object[0]);
        }
        catch (RuntimeException exc) {
            throw new ImageSerializationException(exc, "Failed to read image", new Object[0]);
        }
    }

    public static String toBase64String(BufferedImage bufferedImage) throws SerializeException {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", output);
            return new Base64().encodeToString(output.toByteArray());
        }
        catch (IOException exc) {
            throw new ImageSerializationException(exc);
        }
        catch (RuntimeException exc) {
            throw new ImageSerializationException(exc);
        }
    }

    public static BufferedImage fromBase64String(String encodedImage) throws SerializeException {
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(new Base64().decode(encodedImage));
            BufferedImage image = ImageIO.read(input);
            ImageSerializer.checkImage(image);
            return image;
        }
        catch (IOException exc) {
            throw new ImageSerializationException(exc);
        }
        catch (RuntimeException exc) {
            throw new ImageSerializationException(exc);
        }
        catch (SerializeException exc) {
            logger.debug("Encoded image data: %s", encodedImage);
            throw exc;
        }
    }

    public static byte[] toBase64(BufferedImage bufferedImage) throws SerializeException {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", output);
            return new Base64().encode(output.toByteArray());
        }
        catch (IOException exc) {
            throw new ImageSerializationException(exc);
        }
        catch (RuntimeException exc) {
            throw new ImageSerializationException(exc);
        }
    }

    public static BufferedImage fromBase64(byte[] encodedImage) throws SerializeException {
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(new Base64().decode(encodedImage));
            BufferedImage image = ImageIO.read(input);
            ImageSerializer.checkImage(image);
            return image;
        }
        catch (IOException exc) {
            throw new ImageSerializationException(exc);
        }
        catch (RuntimeException exc) {
            throw new ImageSerializationException(exc);
        }
        catch (SerializeException exc) {
            logger.debug("Encoded image data: %s", Arrays.toString(encodedImage));
            throw exc;
        }
    }

    private static void checkImage(BufferedImage image) throws SerializeException {
        if (image == null) {
            throw new ImageSerializationException("Unknown image file format", new Object[0]);
        }
    }

    public static boolean compareEncodedImages(byte[] firstImage, byte[] secondImage) {
        if (firstImage != null && secondImage != null && firstImage.length == secondImage.length) {
            for (int i = 0; i < firstImage.length; ++i) {
                if (firstImage[i] == secondImage[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

