/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.http;

import at.mrdevelopment.toolkit.http.XMLContentProducer;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.apache.http.entity.ContentProducer;
import org.w3c.dom.Document;

public class XMLContentProducerFactory {
    private final TransformerFactory transformerFactory = TransformerFactory.newInstance();

    public static XMLContentProducerFactory newInstance() {
        return new XMLContentProducerFactory();
    }

    private XMLContentProducerFactory() {
    }

    public ContentProducer createContentProducer(Document document, String styleSheet) throws SerializeException {
        Transformer plainTransformer = this.createPlainTransformer();
        return new XMLContentProducer(document, plainTransformer, styleSheet);
    }

    public ContentProducer createContentProducer(Document document) throws SerializeException {
        Transformer plainTransformer = this.createPlainTransformer();
        return new XMLContentProducer(document, plainTransformer, null);
    }

    private Transformer createPlainTransformer() throws SerializeException {
        try {
            Transformer transformer = this.transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            return transformer;
        }
        catch (TransformerConfigurationException exc) {
            throw new SerializeException(exc);
        }
    }

    public String toString(Document document, String styleSheet) throws SerializeException, IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ContentProducer contentProducer = this.createContentProducer(document, styleSheet);
        contentProducer.writeTo((OutputStream)outputStream);
        return outputStream.toString("UTF-8");
    }

    public String toString(Document document) throws SerializeException, IOException {
        return this.toString(document, null);
    }
}

