/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.http;

import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.http.entity.ContentProducer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;

public class XMLContentProducer
implements ContentProducer {
    static ESLLogger logger = ESLLogger.getLogger(XMLContentProducer.class);
    private final Document document;
    private final Transformer transformer;
    private final String styleSheet;

    public XMLContentProducer(Document document, Transformer transformer, String styleSheet) {
        this.document = document;
        this.transformer = transformer;
        this.styleSheet = styleSheet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outputStream) throws IOException {
        try {
            if (this.styleSheet != null) {
                Element element = this.document.getDocumentElement();
                ProcessingInstruction processingInstruction = this.document.createProcessingInstruction("xml-stylesheet", String.format("type=\"text/xsl\" href=\"%s\"", this.styleSheet));
                this.document.insertBefore(processingInstruction, element);
            }
            DOMSource source = new DOMSource(this.document);
            StreamResult result = new StreamResult(outputStream);
            Transformer transformer = this.transformer;
            synchronized (transformer) {
                this.transformer.transform(source, result);
            }
        }
        catch (TransformerException exc) {
            throw new IOException(exc);
        }
    }
}

