/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.http;

import at.mrdevelopment.toolkit.http.BasicHttpRequestHandler;
import at.mrdevelopment.toolkit.http.HttpContentType;
import at.mrdevelopment.toolkit.http.ImageContentProducer;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.awt.image.BufferedImage;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.w3c.dom.Document;

public class WebserviceResponse {
    private BasicHttpRequestHandler requestHandler;
    private HttpResponse response;

    public WebserviceResponse(BasicHttpRequestHandler requestHandler, HttpResponse response) {
        this.requestHandler = requestHandler;
        this.response = response;
    }

    public void respondMessage(String message, int statusCode) throws SerializeException {
        this.requestHandler.respondMessage(this.response, message, statusCode);
    }

    public void respondMessage(String message) throws SerializeException {
        this.respondMessage(message, 200);
    }

    public void respondBadRequest() throws SerializeException {
        this.respondMessage("Bad request", 400);
    }

    public void respondFileNotFound(String message) throws SerializeException {
        this.respondMessage(message, 404);
    }

    public void respondImage(BufferedImage image) {
        EntityTemplate body = new EntityTemplate((ContentProducer)new ImageContentProducer(image));
        body.setContentType(HttpContentType.PNG.getValue());
        this.respondEntity((HttpEntity)body, 200);
    }

    public void respondFileNotFound() throws SerializeException {
        this.respondFileNotFound("File not found");
    }

    public void respondInternalServerError(Throwable cause) {
        this.requestHandler.respondInternalServerError(this.response, cause);
    }

    public void respondUnauthorized() {
        this.requestHandler.respondUnauthorized(this.response);
    }

    public void respondDocument(Document document, boolean gzipEncodingAccepted) throws SerializeException {
        this.requestHandler.respondDocument(this.response, document, HttpContentType.XML, gzipEncodingAccepted);
    }

    public void respondContentProducer(ContentProducer contentProducer, HttpContentType contentType, boolean gzipEncodingAccepted) {
        this.requestHandler.respondContentProducer(this.response, contentProducer, contentType, gzipEncodingAccepted);
    }

    public void respondPlainText(String text) {
        this.requestHandler.respondPlainText(this.response, text);
    }

    public void redirect(String targetUri) {
        this.requestHandler.redirect(this.response, targetUri);
    }

    public void respondEntity(HttpEntity entity, int statusCode) {
        this.response.setEntity(entity);
        this.response.setStatusCode(statusCode);
    }
}

