/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.http;

import at.mrdevelopment.toolkit.http.HttpContentType;
import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.Route;
import at.mrdevelopment.toolkit.http.WebserviceRequest;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.InputStreamEntity;

public class StaticFileHttpRequestHandler
implements WebserviceRequestHandler {
    private final String directoryIndex;
    private final String documentRoot;

    public StaticFileHttpRequestHandler(String directoryIndex, String documentRoot) {
        this.directoryIndex = directoryIndex;
        this.documentRoot = documentRoot;
    }

    @Route(method=HttpRequestMethod.GET, route="/.*")
    public void getFile(WebserviceRequest request, WebserviceResponse response) throws Exception {
        String requestPath = request.getRequestUri().getPath();
        String localPath = this.documentRoot + (requestPath.endsWith("/") ? requestPath + this.directoryIndex : requestPath);
        InputStream ressourceStream = StaticFileHttpRequestHandler.class.getResourceAsStream(localPath);
        if (ressourceStream != null) {
            InputStreamEntity body = new InputStreamEntity(ressourceStream, -1L);
            body.setContentType(this.getContentType(localPath).getValue());
            response.respondEntity((HttpEntity)body, 200);
        } else {
            response.respondFileNotFound();
        }
    }

    private HttpContentType getContentType(String path) {
        String fileExtension = FilenameUtils.getExtension((String)path);
        if (fileExtension.equals("css")) {
            return HttpContentType.CSS;
        }
        if (fileExtension.equals("xsl")) {
            return HttpContentType.XML;
        }
        if (fileExtension.equals("xml")) {
            return HttpContentType.XML;
        }
        if (fileExtension.equals("png")) {
            return HttpContentType.PNG;
        }
        return HttpContentType.HTML_UTF8;
    }

    @Override
    public String getRouteFromPattern(String route) {
        return route;
    }
}

