/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.http;

import at.mrdevelopment.toolkit.http.ResponseHandler;
import at.mrdevelopment.toolkit.http.UnauthorizedException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;

public class ResponseHandlerWrapper<T>
implements org.apache.http.client.ResponseHandler<T> {
    static ESLLogger logger = ESLLogger.getLogger(ResponseHandlerWrapper.class);
    private final ResponseHandler<T> responseHandler;

    public ResponseHandlerWrapper(ResponseHandler<T> responseHandler) {
        this.responseHandler = responseHandler;
    }

    public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 401) {
            throw new ClientProtocolException((Throwable)new UnauthorizedException());
        }
        if (statusCode == 500) {
            throw new ClientProtocolException("Request failed because of an internal server error");
        }
        if (statusCode != 200) {
            throw new ClientProtocolException(String.format("Request failed with status %d: %s", statusCode, response.getStatusLine().getReasonPhrase()));
        }
        try {
            return this.responseHandler.handleResponse(response);
        }
        catch (IOException exc) {
            throw exc;
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled(exc);
            throw new ClientProtocolException((Throwable)exc);
        }
    }
}

