/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.http;

import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.http.HttpWorker;
import at.mrdevelopment.toolkit.http.HttpWorkerThreadFactory;
import at.mrdevelopment.toolkit.http.WebserviceException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpServerConnection;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.DefaultHttpServerConnection;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandlerResolver;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;

public class RequestListenerThread
extends Thread
implements Shutdownable {
    static ESLLogger logger = ESLLogger.getLogger(RequestListenerThread.class);
    private final ServerSocket serverSocket;
    private final HttpParams params;
    private final HttpService httpService;
    private final ExecutorService executor;
    private volatile boolean shutdownRequested = false;

    public RequestListenerThread(int port, boolean useSSL, HttpRequestHandlerResolver registry, int threadPoolSize, int workerThreadPriority) throws WebserviceException {
        super(String.format("%s-request-listener-port-%d", useSSL ? "https" : "http", port));
        try {
            this.serverSocket = this.createServerSocket(port, useSSL);
            this.params = new BasicHttpParams();
            this.params.setIntParameter("http.socket.timeout", 30000).setIntParameter("http.socket.buffer-size", 8192).setBooleanParameter("http.connection.stalecheck", false).setBooleanParameter("http.tcp.nodelay", true).setParameter("http.origin-server", (Object)"HttpComponents/1.1");
            BasicHttpProcessor httpProcessor = new BasicHttpProcessor();
            httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseDate());
            httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseServer());
            httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseContent());
            httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
            this.httpService = new HttpService((HttpProcessor)httpProcessor, (ConnectionReuseStrategy)new DefaultConnectionReuseStrategy(), (HttpResponseFactory)new DefaultHttpResponseFactory(), registry, this.params);
            HttpWorkerThreadFactory threadFactory = new HttpWorkerThreadFactory(workerThreadPriority);
            this.executor = Executors.newFixedThreadPool(threadPoolSize, threadFactory);
        }
        catch (Exception exc) {
            throw new WebserviceException(exc);
        }
    }

    private ServerSocket createServerSocket(int port, boolean useSSLSocket) throws IOException {
        if (useSSLSocket) {
            return SSLServerSocketFactory.getDefault().createServerSocket(port);
        }
        return new ServerSocket(port);
    }

    @Override
    public void shutdown() {
        logger.info("Shutdown RequestListenerThread");
        this.shutdownRequested = true;
        this.executor.shutdownNow();
        this.interrupt();
    }

    @Override
    public void interrupt() {
        super.interrupt();
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        logger.info("Listening on port " + this.serverSocket.getLocalPort());
        while (!this.shutdownRequested) {
            try {
                Socket socket = this.serverSocket.accept();
                DefaultHttpServerConnection connection = new DefaultHttpServerConnection();
                connection.bind(socket, this.params);
                HttpWorker worker = new HttpWorker(this.httpService, (HttpServerConnection)connection);
                this.executor.execute(worker);
            }
            catch (SocketException exc) {
                if (this.shutdownRequested) continue;
                logger.warn("Socket error while initialising worker thread: " + exc.getMessage());
                break;
            }
            catch (IOException exc) {
                logger.warn("HTTP input/output error while initialising worker thread: " + exc.getMessage());
            }
        }
    }
}

