/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.http;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.http.HttpEntity;

public class MultipartFileParser {
    public File writeFileFromStream(HttpEntity body, String toBasepath, String fileExtension) throws IllegalStateException, IOException {
        File file = null;
        String contentType = body.getContentType().getValue();
        int boundaryIndex = contentType.indexOf("boundary=");
        byte[] boundary = contentType.substring(boundaryIndex + 9).getBytes();
        MultipartStream multipartStream = new MultipartStream(body.getContent(), boundary);
        boolean nextPart = multipartStream.skipPreamble();
        while (nextPart) {
            String[] headers = multipartStream.readHeaders().split(";");
            String filename = null;
            for (String header : headers) {
                if (!header.contains("filename")) continue;
                filename = header.split("[=|\"]")[2];
            }
            if (filename == null) continue;
            if (fileExtension != null && fileExtension.length() > 0 && !filename.toLowerCase().endsWith(fileExtension)) {
                return null;
            }
            file = new File(toBasepath + "/" + filename);
            FileOutputStream data = new FileOutputStream(file);
            multipartStream.readBodyData((OutputStream)data);
            nextPart = multipartStream.readBoundary();
        }
        return file;
    }
}

