/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.http;

import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.IOException;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpException;
import org.apache.http.HttpServerConnection;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpService;

public class HttpWorker
implements Runnable {
    static ESLLogger logger = ESLLogger.getLogger(HttpWorker.class);
    private final HttpService service;
    private final HttpServerConnection connection;

    public HttpWorker(HttpService service, HttpServerConnection connection) {
        this.service = service;
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BasicHttpContext context = new BasicHttpContext(null);
        try {
            this.service.handleRequest(this.connection, (HttpContext)context);
        }
        catch (ConnectionClosedException exc) {
            logger.warn("Client closed connection");
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (IOException exc) {
            logger.warn("HTTP input/output error: " + exc.getMessage());
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (HttpException exc) {
            logger.warn("Unrecoverable HTTP protocol violation: " + exc.getMessage());
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (Exception exc) {
            logger.logException(exc);
        }
        finally {
            try {
                this.connection.shutdown();
            }
            catch (IOException ignore) {}
        }
    }
}

