/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.http;

import at.mrdevelopment.toolkit.Abortable;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.RequestAbortable;
import at.mrdevelopment.toolkit.http.CustomTrustManager;
import at.mrdevelopment.toolkit.http.IgnoreRequestFailedHandler;
import at.mrdevelopment.toolkit.http.RequestAbortedException;
import at.mrdevelopment.toolkit.http.RequestFailedHandler;
import at.mrdevelopment.toolkit.http.RequestListener;
import at.mrdevelopment.toolkit.http.ResponseHandler;
import at.mrdevelopment.toolkit.http.ResponseHandlerWrapper;
import at.mrdevelopment.toolkit.http.WebserviceException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.AbortableHttpRequest;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class HttpServiceClient {
    static ESLLogger logger = ESLLogger.getLogger(HttpServiceClient.class);
    private static final int CONNECTION_TIMEOUT = 30000;
    private static final int SOCKET_TIMEOUT = 120000;
    private final Set<RequestListener> listeners = new CopyOnWriteArraySet<RequestListener>();
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final SchemeRegistry supportedSchemes;
    private final BasicHttpParams params;
    private final CredentialsProvider credentialsProvider;
    private final HttpHost httpHost;

    public HttpServiceClient(String host, int port, boolean useSSL) throws InitializationException {
        try {
            this.httpHost = new HttpHost(host, port, useSSL ? "https" : "http");
            CustomTrustManager certificateTrustManager = new CustomTrustManager();
            logger.info("Imported %d accepted issuers", certificateTrustManager.getAcceptedIssuers().length);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{certificateTrustManager}, null);
            SSLSocketFactory socketFactory = new SSLSocketFactory(sslContext, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            this.supportedSchemes = new SchemeRegistry();
            this.supportedSchemes.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
            this.supportedSchemes.register(new Scheme("https", 443, (SchemeSocketFactory)socketFactory));
            this.params = new BasicHttpParams();
            HttpProtocolParams.setVersion((HttpParams)this.params, (ProtocolVersion)HttpVersion.HTTP_1_1);
            HttpProtocolParams.setContentCharset((HttpParams)this.params, (String)"UTF-8");
            HttpProtocolParams.setUseExpectContinue((HttpParams)this.params, (boolean)true);
            HttpConnectionParams.setConnectionTimeout((HttpParams)this.params, (int)30000);
            HttpConnectionParams.setSoTimeout((HttpParams)this.params, (int)120000);
            this.credentialsProvider = new BasicCredentialsProvider();
        }
        catch (Exception exc) {
            throw new InitializationException(exc);
        }
    }

    public String getHost() {
        return this.httpHost.getHostName();
    }

    public int getPort() {
        return this.httpHost.getPort();
    }

    public void setCredentials(String username, String password) {
        AuthScope authScope = new AuthScope(this.httpHost.getHostName(), this.httpHost.getPort());
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
        this.credentialsProvider.setCredentials(authScope, (Credentials)credentials);
    }

    public <T> T executeRequest(HttpRequestBase request, ResponseHandler<T> responseHandler) throws WebserviceException {
        return this.executeRequest(request, responseHandler, new IgnoreRequestFailedHandler(), false);
    }

    public <T> T executeRequest(HttpRequestBase request, ResponseHandler<T> responseHandler, RequestFailedHandler failedHandler) throws WebserviceException {
        return this.executeRequest(request, responseHandler, failedHandler, false);
    }

    public <T> Abortable executeRequestAsync(HttpRequestBase request, ResponseHandler<T> responseHandler) {
        return this.executeRequestAsync(request, responseHandler, new IgnoreRequestFailedHandler());
    }

    public <T> Abortable executeRequestAsync(final HttpRequestBase request, final ResponseHandler<T> responseHandler, final RequestFailedHandler failedHandler) {
        FutureTask requestTask = new FutureTask(new Callable<T>(){

            @Override
            public T call() throws WebserviceException {
                try {
                    return HttpServiceClient.this.executeRequest(request, responseHandler, failedHandler, true);
                }
                catch (RequestAbortedException exc) {
                    throw exc;
                }
                catch (WebserviceException exc) {
                    throw exc;
                }
            }
        });
        this.executor.execute(requestTask);
        return new RequestAbortable(requestTask, (AbortableHttpRequest)request);
    }

    public void close() {
        logger.info("Closing open connections");
    }

    public void addRequestListener(RequestListener listener) {
        this.listeners.add(listener);
    }

    public void removeRequestListener(RequestListener listener) {
        this.listeners.remove(listener);
    }

    private <T> T executeRequest(HttpRequestBase request, ResponseHandler<T> responseHandler, RequestFailedHandler failedHandler, boolean asynchron) throws WebserviceException {
        logger.info("Executing request %s %s", request.getMethod(), request.getRequestLine().getUri());
        this.notifyRequestCreated(request);
        try {
            SingleClientConnManager connectionManager = new SingleClientConnManager(this.supportedSchemes);
            DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)connectionManager, (HttpParams)this.params);
            httpClient.setCredentialsProvider(this.credentialsProvider);
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicScheme = new BasicScheme();
            authCache.put(this.httpHost, (AuthScheme)basicScheme);
            BasicHttpContext httpContext = new BasicHttpContext();
            httpContext.setAttribute("http.auth.auth-cache", (Object)authCache);
            Object result = httpClient.execute(this.httpHost, (HttpRequest)request, new ResponseHandlerWrapper<T>(responseHandler), (HttpContext)httpContext);
            this.notifyRequestFinished(request);
            return (T)result;
        }
        catch (HttpHostConnectException exc) {
            WebserviceException connectException = new WebserviceException("Could not connect to %s service at %s:%d", this.httpHost.getSchemeName().toUpperCase(), this.httpHost.getHostName(), this.httpHost.getPort());
            this.notifyRequestFailed(request, asynchron, connectException);
            failedHandler.requestFailed();
            throw connectException;
        }
        catch (SSLPeerUnverifiedException exc) {
            WebserviceException certificateException = new WebserviceException("Could not verify server certificate for %s", this.httpHost.getHostName());
            this.notifyRequestFailed(request, asynchron, certificateException);
            failedHandler.requestFailed();
            throw certificateException;
        }
        catch (ClientProtocolException exc) {
            if (exc.getCause() != null && exc.getCause() instanceof WebserviceException) {
                this.notifyRequestFailed(request, asynchron, exc.getCause());
                failedHandler.requestFailed();
                throw (WebserviceException)exc.getCause();
            }
            WebserviceException protocolException = new WebserviceException(exc);
            this.notifyRequestFailed(request, asynchron, protocolException);
            failedHandler.requestFailed();
            throw protocolException;
        }
        catch (Exception exc) {
            if (request.isAborted()) {
                logger.info("Aborted request %s %s", request.getMethod(), request.getRequestLine().getUri());
                this.notifyRequestAborted(request);
                failedHandler.requestAborted();
                throw new RequestAbortedException();
            }
            logger.logExceptionIfDebugEnabled(exc);
            this.notifyRequestFailed(request, asynchron, exc);
            failedHandler.requestFailed();
            throw new WebserviceException(exc);
        }
    }

    private void notifyRequestCreated(HttpRequestBase request) {
        for (RequestListener listener : this.listeners) {
            listener.requestCreated(request);
        }
    }

    private void notifyRequestFinished(HttpRequestBase request) {
        for (RequestListener listener : this.listeners) {
            listener.requestFinished(request);
        }
    }

    private void notifyRequestFailed(HttpRequestBase request, boolean reportException, Throwable exc) {
        for (RequestListener listener : this.listeners) {
            if (reportException) {
                listener.requestFailed(request, exc);
                continue;
            }
            listener.requestFailed(request);
        }
    }

    private void notifyRequestAborted(HttpRequestBase request) {
        for (RequestListener listener : this.listeners) {
            listener.requestAborted(request);
        }
    }
}

