/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.http;

import at.mrdevelopment.toolkit.http.BasicHttpRequestHandler;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerResolver;

public class BasicHttpRequestHandlerResolver
implements HttpRequestHandlerResolver {
    static ESLLogger logger = ESLLogger.getLogger(BasicHttpRequestHandlerResolver.class);
    private final List<BasicHttpRequestHandler> handlers = new ArrayList<BasicHttpRequestHandler>();

    public HttpRequestHandler lookup(String uri) {
        try {
            URI requestUri = new URI(uri);
            for (BasicHttpRequestHandler handler : this.handlers) {
                if (!handler.lookup(requestUri)) continue;
                return handler;
            }
        }
        catch (URISyntaxException exc) {
            logger.logException(exc);
        }
        return null;
    }

    public void register(BasicHttpRequestHandler handler) {
        this.handlers.add(handler);
    }
}

