/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.http;

import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.http.Authentication;
import at.mrdevelopment.toolkit.http.GZIPContentProducer;
import at.mrdevelopment.toolkit.http.HttpContentType;
import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.RequestRoutingTable;
import at.mrdevelopment.toolkit.http.Restrict;
import at.mrdevelopment.toolkit.http.Route;
import at.mrdevelopment.toolkit.http.Routes;
import at.mrdevelopment.toolkit.http.WebserviceRequest;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import at.mrdevelopment.toolkit.http.XMLContentProducerFactory;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.ExceptionXMLSerializer;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.w3c.dom.Document;

public final class BasicHttpRequestHandler
implements HttpRequestHandler {
    static ESLLogger logger = ESLLogger.getLogger(BasicHttpRequestHandler.class);
    private final String styleSheet;
    private final Authentication authentication;
    private final ExceptionXMLSerializer exceptionXMLSerializer;
    private final XMLContentProducerFactory contentProducerFactory;
    private final RequestRoutingTable routingTable;

    public BasicHttpRequestHandler(WebserviceRequestHandler requestHandler, String styleSheet, Authentication authentication, ExceptionXMLSerializer exceptionXMLSerializer) {
        this.styleSheet = styleSheet;
        this.authentication = authentication;
        this.exceptionXMLSerializer = exceptionXMLSerializer;
        this.contentProducerFactory = XMLContentProducerFactory.newInstance();
        this.routingTable = new RequestRoutingTable();
        this.buildRoutingTable(requestHandler);
    }

    private void buildRoutingTable(WebserviceRequestHandler handler) {
        Method[] methods;
        for (Method handlerMethod : methods = handler.getClass().getMethods()) {
            for (Annotation annotation : handlerMethod.getDeclaredAnnotations()) {
                if (annotation.annotationType() == Routes.class) {
                    Routes routes = (Routes)annotation;
                    for (Route route : routes.value()) {
                        this.processRoute(handler, route, handlerMethod);
                    }
                    continue;
                }
                if (annotation.annotationType() != Route.class) continue;
                Route route = (Route)annotation;
                this.processRoute(handler, route, handlerMethod);
            }
        }
    }

    private void processRoute(WebserviceRequestHandler handler, Route route, Method execution) {
        String routePath = route.route();
        HttpRequestMethod requestMethod = route.method();
        Route classRoute = handler.getClass().getAnnotation(Route.class);
        String pattern = route.pattern();
        if (classRoute != null && !routePath.startsWith("/")) {
            routePath = classRoute.route() + "/" + routePath;
        }
        this.checkRequestHandlerSignature(execution);
        this.routingTable.addRoute(handler.getRouteFromPattern(routePath), handler, execution, requestMethod, pattern);
    }

    private void checkRequestHandlerSignature(Method requestHandler) {
        Class<?>[] arguments = requestHandler.getParameterTypes();
        if (arguments.length != 2) {
            throw new RuntimeException("Illegal request handler: Wrong number of arguments");
        }
        if (arguments[0] != WebserviceRequest.class) {
            throw new RuntimeException("Illegal request handler: Wrong argument type");
        }
        if (arguments[1] != WebserviceResponse.class) {
            throw new RuntimeException("Illegal request handler: Wrong argument type");
        }
    }

    public boolean lookup(URI uri) {
        return this.routingTable.lookup(uri);
    }

    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        block10: {
            try {
                URI requestUri = new URI(request.getRequestLine().getUri());
                String requestMethod = request.getRequestLine().getMethod();
                logger.info("Handling %s request %s", requestMethod, requestUri);
                UserId user = this.authentication.authorize(request);
                if (user.isAuthorized()) {
                    RequestRoutingTable.RoutingEntry routingEntry = this.routingTable.getRoutingEntry(requestUri, requestMethod);
                    HttpEntity body = this.getRequestBody(request);
                    HttpInetConnection connection = (HttpInetConnection)context.getAttribute("http.connection");
                    InetAddress remoteHost = connection.getRemoteAddress();
                    boolean gzipEncodingAccepted = this.isGzipEncodingAccpeted(request);
                    WebserviceRequest webserviceRequest = new WebserviceRequest(requestUri, remoteHost, gzipEncodingAccepted, user, body);
                    WebserviceResponse webserviceResponse = new WebserviceResponse(this, response);
                    if (routingEntry != null) {
                        block9: {
                            WebserviceRequestHandler handler = routingEntry.getHandler();
                            Method execution = routingEntry.getExecution();
                            if (this.checkPermission(execution, user.getRole())) {
                                logger.info("Invoking %s.%s", handler.getClass().getSimpleName(), execution.getName());
                                try {
                                    execution.invoke((Object)handler, webserviceRequest, webserviceResponse);
                                }
                                catch (InvocationTargetException exc) {
                                    Throwable cause = exc.getCause();
                                    if (cause instanceof IllegalArgumentException) {
                                        logger.warn("Illegal webservice request parameter: " + cause.getMessage());
                                        break block9;
                                    }
                                    logger.logException(cause);
                                    this.respondInternalServerError(response, cause);
                                }
                            } else {
                                logger.info("Missing permissions for %s to run %s.%s", user.getUsername(), handler.getClass().getSimpleName(), execution.getName());
                                this.respondUnauthorized(response);
                            }
                        }
                        return;
                    }
                    this.respondBadRequest(response);
                    break block10;
                }
                this.respondUnauthorized(response);
            }
            catch (Exception exc) {
                logger.logException(exc);
                this.respondInternalServerError(response, exc);
            }
        }
    }

    private HttpEntity getRequestBody(HttpRequest request) {
        if (request instanceof HttpEntityEnclosingRequest) {
            return ((HttpEntityEnclosingRequest)request).getEntity();
        }
        return null;
    }

    private boolean isGzipEncodingAccpeted(HttpRequest request) {
        Header acceptedEncodingHeader = request.getFirstHeader("Accept-Encoding");
        if (acceptedEncodingHeader != null) {
            String[] acceptedEncodings;
            for (String acceptedEncoding : acceptedEncodings = StringUtils.split((String)acceptedEncodingHeader.getValue(), (char)',')) {
                if (!acceptedEncoding.equals("gzip")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkPermission(Method execution, Role role) {
        Restrict restriction = execution.getAnnotation(Restrict.class);
        if (restriction != null) {
            return role.getAccessLevel() >= restriction.value().getAccessLevel();
        }
        return true;
    }

    protected final void respondMessage(HttpResponse response, String message) throws SerializeException {
        this.respondMessage(response, message, 200);
    }

    protected final void respondMessage(HttpResponse response, String message, int statusCode) throws SerializeException {
        Document document = this.exceptionXMLSerializer.messageToXML(statusCode, message);
        ContentProducer contentProducer = this.contentProducerFactory.createContentProducer(document, this.styleSheet);
        EntityTemplate body = new EntityTemplate(contentProducer);
        body.setContentType(HttpContentType.XML.getValue());
        response.setStatusCode(statusCode);
        response.setEntity((HttpEntity)body);
    }

    protected final void respondBadRequest(HttpResponse response) throws SerializeException {
        this.respondMessage(response, "Bad request", 400);
    }

    protected final void respondFileNotFound(HttpResponse response) throws SerializeException {
        this.respondFileNotFound(response, "File not found");
    }

    protected final void respondFileNotFound(HttpResponse response, String message) throws SerializeException {
        this.respondMessage(response, message, 404);
    }

    protected final void respondInternalServerError(HttpResponse response, Throwable cause) {
        response.setStatusCode(500);
        try {
            Document document = this.exceptionXMLSerializer.toXML(cause);
            ContentProducer contentProducer = this.contentProducerFactory.createContentProducer(document, this.styleSheet);
            EntityTemplate body = new EntityTemplate(contentProducer);
            body.setContentType(HttpContentType.XML.getValue());
            response.setEntity((HttpEntity)body);
        }
        catch (Exception exc) {
            try {
                StringEntity body = new StringEntity("Internal Server Error");
                body.setContentType(HttpContentType.PLAIN.getValue());
                response.setEntity((HttpEntity)body);
            }
            catch (UnsupportedEncodingException ignore) {
                // empty catch block
            }
            logger.error("Exception during internal server error response: %s", exc.getMessage());
            logger.logExceptionIfDebugEnabled(exc);
        }
    }

    protected final void respondUnauthorized(HttpResponse response) {
        this.authentication.responseUnauthorized(response);
    }

    protected final void respondDocument(HttpResponse response, Document document, HttpContentType contentType, boolean gzipEncodingAccepted) throws SerializeException {
        ContentProducer contentProducer = this.contentProducerFactory.createContentProducer(document, this.styleSheet);
        this.respondContentProducer(response, contentProducer, contentType, gzipEncodingAccepted);
    }

    protected final void respondContentProducer(HttpResponse response, ContentProducer contentProducer, HttpContentType contentType, boolean gzipEncodingAccepted) {
        if (gzipEncodingAccepted) {
            response.setHeader("Content-Encoding", "gzip");
            contentProducer = new GZIPContentProducer(contentProducer);
        }
        EntityTemplate body = new EntityTemplate(contentProducer);
        body.setContentType(contentType.getValue());
        response.setStatusCode(200);
        response.setEntity((HttpEntity)body);
    }

    protected final void respondPlainText(HttpResponse response, String text) {
        try {
            StringEntity body = new StringEntity(text);
            body.setContentType(HttpContentType.PLAIN.getValue());
            response.setStatusCode(200);
            response.setEntity((HttpEntity)body);
        }
        catch (UnsupportedEncodingException exc) {
            this.respondInternalServerError(response, exc);
        }
    }

    protected final void redirect(HttpResponse response, String targetUri) {
        response.addHeader("location", targetUri);
        response.setStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 307, targetUri);
    }
}

