/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.http;

import at.mrdevelopment.toolkit.authentication.Authenticator;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.http.Authentication;
import at.mrdevelopment.toolkit.http.RequestUser;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;

public class BasicAuthentication
implements Authentication {
    static ESLLogger logger = ESLLogger.getLogger(BasicAuthentication.class);
    private final Authenticator authenticator;
    private final String realm;

    public BasicAuthentication(Authenticator authenticator, String realm) {
        this.authenticator = authenticator;
        this.realm = realm;
    }

    @Override
    public UserId authorize(HttpRequest request) {
        Header authorizationHeader = request.getFirstHeader("Authorization");
        if (authorizationHeader == null) {
            logger.info("Missing authorization header");
            return new RequestUser(Role.NONE);
        }
        String value = authorizationHeader.getValue();
        String[] parts = StringUtils.split((String)value);
        if (parts.length != 2) {
            logger.warn("Not a valid authentication request (%s)", value);
            return new RequestUser(Role.NONE);
        }
        if (!parts[0].equals("Basic")) {
            logger.warn("Not a basic authentication request (%s)", value);
            return new RequestUser(Role.NONE);
        }
        if (parts[0] == null || parts[1] == null) {
            logger.warn("Malformed basic authentication request (%s)", value);
            return new RequestUser(Role.NONE);
        }
        String decodedAuth = new String(new Base64().decode(parts[1]));
        if ((parts = StringUtils.split((String)decodedAuth, (char)':')).length != 2) {
            logger.warn("Malformed basic authentication request (%s)", value);
            return new RequestUser(Role.NONE);
        }
        String username = parts[0];
        String password = parts[1];
        UserId user = this.authenticator.authorize(username, password);
        logger.info("Basic authentication request with username %s, password ***** %s", username, user.isAuthorized() ? "successful" : "failed");
        return user;
    }

    @Override
    public void responseUnauthorized(HttpResponse response) {
        try {
            response.setStatusCode(401);
            response.addHeader((Header)new BasicHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\""));
            StringEntity body = new StringEntity("Unauthorized");
            response.setEntity((HttpEntity)body);
        }
        catch (UnsupportedEncodingException exc) {
            logger.logException(exc);
        }
    }
}

