/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.gui.resizeable;

import at.mrdevelopment.toolkit.gui.Canvas;
import at.mrdevelopment.toolkit.gui.CanvasElement;
import at.mrdevelopment.toolkit.gui.InsertionMode;
import at.mrdevelopment.toolkit.gui.ViewState;
import at.mrdevelopment.toolkit.gui.resizeable.CanvasBorder;
import at.mrdevelopment.toolkit.gui.resizeable.ResizeableBorder;
import at.mrdevelopment.toolkit.gui.resizeable.TwoPointInsertBorder;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;

public class InsertingCanvasElement
extends CanvasElement {
    private static final int ABSOLUTE_MIN_SIZE = 5;
    private static int ID = Integer.MAX_VALUE;
    private final int imageWidth;
    private final int imageHeight;
    private final int rotation;
    private int lastCursor;
    private int mouseX;
    private int mouseY;
    private int oldX;
    private int oldY;

    public InsertingCanvasElement(InsertionMode insertionMode, Canvas parent, int x, int y, Shape origBounds, int imageWidth, int imageHeight, int rotation) {
        super(parent, ID--, x, y, 0, 0, origBounds, insertionMode.isRectangle() ? new ResizeableBorder() : new TwoPointInsertBorder());
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.rotation = rotation;
    }

    @Override
    public void paint(Graphics graphics) {
        this.getCanvasBorder().paintBorder(graphics, this.getBounds(), this.getBounds().getBounds().x, this.getBounds().getBounds().y, this.getBounds().getBounds().width, this.getBounds().getBounds().height, CanvasBorder.BorderStyle.FULL_FOCUS, this.mouseX, this.mouseY, this.oldX, this.oldY);
    }

    @Override
    public void handleMouseDragged(MouseEvent me, int dx, int dy, int oldX, int oldY, int oldWidth, int oldHeight, Shape shape) {
        ViewState viewState = this.getParent().getViewState();
        int maxX = viewState.getViewX() + this.getParent().getWidth();
        int maxY = viewState.getViewY() + this.getParent().getHeight();
        this.mouseX = me.getX() < 0 ? 0 : me.getX();
        this.mouseY = me.getY() < 0 ? 0 : me.getY();
        this.mouseX = this.mouseX > maxX ? maxX : this.mouseX;
        this.mouseY = this.mouseY > maxY ? maxY : this.mouseY;
        this.oldX = oldX;
        this.oldY = oldY;
        this.lastCursor = this.calculateCursorType(oldX, oldY, oldWidth, oldHeight, dx, dy);
        Shape bounds = this.calculateNewBounds(me.isShiftDown(), this.lastCursor, dx, dy, viewState.getViewX(), viewState.getViewY(), maxX, maxY, oldX, oldY, oldWidth, oldHeight);
        this.setBounds(bounds);
        this.setOriginalBounds(this.calculateOriginalBounds(bounds.getBounds()));
        this.getParent().getPanel().repaint();
    }

    public Rectangle calculateOriginalBounds(Rectangle bounds) {
        ViewState viewState = this.getParent().getViewState();
        Rectangle newBounds = new Rectangle((bounds.x - viewState.getViewX()) / viewState.getScale(), (bounds.y - viewState.getViewY()) / viewState.getScale(), bounds.width / viewState.getScale(), bounds.height / viewState.getScale());
        if (this.rotation == 90 || this.rotation == 180 || this.rotation == 270) {
            for (int index = 0; index < this.rotation; index += 90) {
                int height = 0;
                if (this.rotation == 180) {
                    height = this.imageWidth;
                    if (index == 90) {
                        height = this.imageHeight;
                    }
                } else {
                    height = this.imageHeight;
                    if (index == 90) {
                        height = this.imageWidth;
                    }
                }
                newBounds = this.rotate90Degrees(newBounds, height);
            }
        }
        return newBounds;
    }

    private Rectangle rotate90Degrees(Rectangle bounds, int height) {
        return new Rectangle(bounds.y, height - bounds.width - bounds.x, bounds.height, bounds.width);
    }

    private int calculateCursorType(int oldX, int oldY, int oldWidth, int oldHeight, int dx, int dy) {
        if (dx > 0 && dy > 0) {
            return 5;
        }
        if (dx > 0 && dy < 0) {
            return 7;
        }
        if (dx < 0 && dy > 0) {
            return 4;
        }
        if (dx == 0 && dy > 0) {
            return 9;
        }
        if (dx == 0 && dy < 0) {
            return 8;
        }
        if (dx > 0 && dy == 0) {
            return 11;
        }
        if (dx < 0 && dy == 0) {
            return 10;
        }
        if (dy < 0 && dy < 0) {
            return 6;
        }
        return 0;
    }

    private Shape calculateNewBounds(boolean proportional, int cursorType, int dx, int dy, int minX, int minY, int maxX, int maxY, int x, int y, int w, int h) {
        int by;
        int rx;
        if (cursorType == 13) {
            if (this.getBounds() instanceof Rectangle) {
                Rectangle bounds = new Rectangle(x, y, w, h);
                bounds.translate(dx, dy);
                bounds.x = Math.max(bounds.x, minX);
                bounds.y = Math.max(bounds.y, minY);
                if (bounds.x + bounds.width > maxX) {
                    bounds.x = maxX - bounds.width;
                }
                if (bounds.y + bounds.height > maxY) {
                    bounds.y = maxY - bounds.height;
                }
                return bounds;
            }
            if (this.getBounds() instanceof Line2D) {
                this.getBounds().getBounds().translate(dx, dy);
                this.getBounds().getBounds().x = Math.max(this.getBounds().getBounds().x, minX);
                this.getBounds().getBounds().y = Math.max(this.getBounds().getBounds().y, minY);
                if (this.getBounds().getBounds().x + this.getBounds().getBounds().width > maxX) {
                    this.getBounds().getBounds().x = maxX - this.getBounds().getBounds().width;
                }
                if (this.getBounds().getBounds().y + this.getBounds().getBounds().height > maxY) {
                    this.getBounds().getBounds().y = maxY - this.getBounds().getBounds().height;
                }
                return this.getBounds();
            }
        }
        if (this.getBounds() instanceof Line2D) {
            int scaledX = Math.round(this.mouseX * this.getParent().getScale());
            int scaledY = Math.round(this.mouseY * this.getParent().getScale());
            return new Line2D.Double(x, y, scaledX, scaledY);
        }
        if (cursorType == 1) {
            int scaledX = Math.round(this.mouseX * this.getParent().getScale());
            int scaledY = Math.round(this.mouseY * this.getParent().getScale());
            return new Line2D.Double(x, y, scaledX, scaledY).getBounds();
        }
        if (proportional) {
            if (cursorType == 5) {
                dx = (int)((float)dy * this.getWidthScale());
            } else if (cursorType == 4) {
                dx = -((int)((float)dy * this.getWidthScale()));
            } else if (cursorType == 7) {
                dy = -((int)((float)dx * this.getHeightScale()));
            } else if (cursorType == 6) {
                dy = (int)((float)dx * this.getHeightScale());
            }
        }
        if ((cursorType == 6 || cursorType == 10 || cursorType == 4) && (w = (rx = x + w) - (x = Math.max(minX, x + dx))) < this.getRelativeMinSize()) {
            w = this.getRelativeMinSize();
            x = Math.max(minX, rx - w);
        }
        if (cursorType == 4 || cursorType == 9 || cursorType == 5) {
            int newH = h + dy;
            if (y + newH > maxY) {
                newH = maxY - y;
            }
            if (newH < this.getRelativeMinSize()) {
                newH = this.getRelativeMinSize();
            }
            h = newH;
        }
        if (cursorType == 5 || cursorType == 11 || cursorType == 7) {
            int newW = w + dx;
            if (x + newW > maxX) {
                newW = maxX - x;
            }
            if (newW < this.getRelativeMinSize()) {
                newW = this.getRelativeMinSize();
            }
            w = newW;
        }
        if ((cursorType == 7 || cursorType == 8 || cursorType == 6) && (h = (by = y + h) - (y = Math.max(minY, y + dy))) < this.getRelativeMinSize()) {
            h = this.getRelativeMinSize();
            y = Math.max(minY, by - h);
        }
        return new Rectangle(x, y, w, h);
    }

    @Override
    public void handleMousePressed(MouseEvent me) {
    }

    @Override
    public void handleMouseClicked(MouseEvent me) {
    }

    @Override
    public void handleMouseReleased(MouseEvent me) {
    }

    @Override
    public int getCursor(int x, int y) {
        return 0;
    }

    private int getRelativeMinSize() {
        return 5 * this.getParent().getScale();
    }
}

