/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.gui.options;

import at.mrdevelopment.toolkit.gui.DisplayableOption;
import at.mrdevelopment.toolkit.gui.event.EventDispatcher;
import at.mrdevelopment.toolkit.gui.event.OptionChangeEvent;
import at.mrdevelopment.toolkit.gui.options.OptionsTableEntry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class SingleButtonEditor
extends AbstractCellEditor
implements TableCellEditor {
    private final JPanel buttonPanel;
    private JTable table;
    private int row;
    private int height = 0;
    private String disabledvalue;
    private String enabledValue;
    private JToggleButton button;
    private boolean buttonSelected;

    public SingleButtonEditor(final EventDispatcher eventDispatcher, final int fieldId, DisplayableOption option, ImageIcon icon, String enabledValue, String disabledvalue) {
        this.enabledValue = enabledValue;
        this.disabledvalue = disabledvalue;
        this.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent paramChangeEvent) {
                OptionsTableEntry optionEntry = (OptionsTableEntry)SingleButtonEditor.this.table.getModel().getValueAt(SingleButtonEditor.this.row, 1);
                OptionChangeEvent oce = new OptionChangeEvent(optionEntry.getPath(), fieldId, SingleButtonEditor.this.getValue());
                eventDispatcher.dispatchEvent(oce);
            }

            @Override
            public void editingCanceled(ChangeEvent paramChangeEvent) {
            }
        });
        this.buttonPanel = this.createButtonPanel(icon, option.getValue());
    }

    private JPanel createButtonPanel(ImageIcon icon, String value) {
        JPanel panel = new JPanel(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        toolBar.setBackground(Color.WHITE);
        panel.add((Component)toolBar, "First");
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setMargin(new Insets(0, 0, 0, 0));
        toolBar.setLayout(new FlowLayout(0, 0, 0));
        this.button = new JToggleButton(icon, value.equals(this.enabledValue));
        this.buttonSelected = this.button.isSelected();
        this.height = Math.max(this.height, icon.getIconHeight() + 10);
        this.button.setFocusable(false);
        this.button.setMargin(new Insets(0, 0, 0, 0));
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleButtonEditor.this.buttonSelected = !SingleButtonEditor.this.buttonSelected;
                SingleButtonEditor.this.button.setSelected(SingleButtonEditor.this.buttonSelected);
                SingleButtonEditor.this.fireEditingStopped();
            }
        });
        toolBar.add(this.button);
        panel.validate();
        return panel;
    }

    protected String getValue() {
        return this.button.isSelected() ? this.enabledValue : this.disabledvalue;
    }

    private void updateValue() {
        if (this.table != null) {
            OptionsTableEntry optionEntry = (OptionsTableEntry)this.table.getModel().getValueAt(this.row, 1);
            String value = optionEntry.getDisplayableOption().getValue();
            this.button.setSelected(value.equals(this.enabledValue));
        }
    }

    public JPanel getPanel(JTable table, int row) {
        this.table = table;
        if (this.height <= 0 || table.getRowHeight(row) != this.height) {
            // empty if block
        }
        this.row = row;
        this.updateValue();
        return this.buttonPanel;
    }

    @Override
    public Object getCellEditorValue() {
        return this.getValue();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return this.getPanel(table, row);
    }
}

