/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.gui.options;

import at.mrdevelopment.toolkit.gui.AbstractView;
import at.mrdevelopment.toolkit.gui.CellEditorFactory;
import at.mrdevelopment.toolkit.gui.DisplayableOption;
import at.mrdevelopment.toolkit.gui.View;
import at.mrdevelopment.toolkit.gui.ViewState;
import at.mrdevelopment.toolkit.gui.event.EventDispatcher;
import at.mrdevelopment.toolkit.gui.options.OptionsTable;
import at.mrdevelopment.toolkit.tree.TreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class OptionsView
extends AbstractView
implements View {
    private JPanel panel;
    private JScrollPane scrollPane;
    private String title;
    private OptionsTable table;

    public OptionsView(String title, CellEditorFactory cellEditorFactory, EventDispatcher eventDispatcher, ViewState viewState) {
        this.title = title;
        this.table = new OptionsTable(cellEditorFactory, eventDispatcher, viewState);
        this.scrollPane = new JScrollPane(this.table);
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)this.scrollPane, "Center");
        this.panel.setVisible(true);
        this.scrollPane.setVisible(true);
    }

    public void update(TreeNode<DisplayableOption, String> treeNode) {
        this.table.update(treeNode);
        this.notifyUpdated();
    }

    public void clearElements() {
        this.table.clearElements();
        this.notifyUpdated();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public Component getComponent() {
        return this.panel;
    }

    @Override
    public String getTitle() {
        return this.title + " (" + this.table.getRowCount() + ")";
    }

    public void addMouseListener(MouseListener listener) {
        this.table.addMouseListener(listener);
    }

    public void cancelEdit() {
        TableCellEditor editor = this.table.getCellEditor();
        if (editor != null) {
            editor.cancelCellEditing();
        }
    }

    public JTable getTable() {
        return this.table;
    }
}

