/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.gui.options;

import at.mrdevelopment.toolkit.gui.DisplayableOption;
import at.mrdevelopment.toolkit.gui.options.OptionsTableEntry;
import at.mrdevelopment.toolkit.tree.TreeNode;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class OptionsTableModel
extends AbstractTableModel {
    public static final int COL_KEY = 0;
    public static final int COL_VALUE = 1;
    private static final int COLUMN_COUNT = 2;
    private List<OptionsTableEntry> elements = new ArrayList<OptionsTableEntry>();

    public void update(TreeNode<DisplayableOption, String> treeNode) {
        this.elements.add(new OptionsTableEntry(treeNode.getNodePath(), treeNode.getNodeElement(), treeNode.getDecorationElement(), treeNode.getId()));
        LinkedList<TreeNode<DisplayableOption, String>> childList = new LinkedList<TreeNode<DisplayableOption, String>>();
        for (TreeNode<DisplayableOption, String> child : treeNode.getNodes()) {
            if (child.hasChildren()) {
                childList.add(child);
                continue;
            }
            childList.addFirst(child);
        }
        for (TreeNode<DisplayableOption, String> child : childList) {
            this.update(child);
        }
        this.fireTableStructureChanged();
    }

    public OptionsTableEntry getTableEntry(int rowIndex) {
        return this.elements.get(rowIndex);
    }

    public void clearElements() {
        this.elements.clear();
    }

    public int getTotalRowCount() {
        return this.elements.size();
    }

    public List<OptionsTableEntry> getAllRows() {
        return this.elements;
    }

    @Override
    public int getRowCount() {
        return this.getVisibleRowCount();
    }

    public int getVisibleRowCount() {
        int visibleRowCount = 0;
        for (OptionsTableEntry element : this.elements) {
            visibleRowCount = element.isVisible() ? visibleRowCount + 1 : visibleRowCount;
        }
        return visibleRowCount;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    public OptionsTableEntry getVisibleRowAt(int row) {
        int currentRow = -1;
        for (int index = 0; index < this.elements.size(); ++index) {
            OptionsTableEntry element = this.elements.get(index);
            if (element.isVisible()) {
                ++currentRow;
            }
            if (currentRow != row) continue;
            return element;
        }
        return null;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.elements.size()) {
            return null;
        }
        if (col >= 2) {
            return null;
        }
        OptionsTableEntry element = this.getVisibleRowAt(row);
        if (element != null) {
            if (col == 0) {
                return element.getPresentationName();
            }
            if (col == 1) {
                return element;
            }
        }
        return "<unknown>";
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return "Key";
        }
        if (col == 1) {
            return "Value";
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }
}

