/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.gui.options;

import at.mrdevelopment.toolkit.gui.DisplayableOption;
import at.mrdevelopment.toolkit.gui.IconUtils;
import at.mrdevelopment.toolkit.gui.SpringUtilities;
import at.mrdevelopment.toolkit.gui.ViewState;
import at.mrdevelopment.toolkit.gui.event.EventDispatcher;
import at.mrdevelopment.toolkit.gui.event.ShowEditOptionDialogEvent;
import at.mrdevelopment.toolkit.gui.options.ButtonEditor;
import at.mrdevelopment.toolkit.gui.options.CellComponentEntry;
import at.mrdevelopment.toolkit.gui.options.ColorTableCell;
import at.mrdevelopment.toolkit.gui.options.OptionsTableEntry;
import at.mrdevelopment.toolkit.gui.options.OptionsTableModel;
import at.mrdevelopment.toolkit.gui.options.SingleButtonEditor;
import at.mrdevelopment.toolkit.image.NodeIcon;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.options.converter.BooleanStringConverter;
import at.mrdevelopment.toolkit.options.converter.ConversionException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class OptionsTableCellRenderer
implements TableCellRenderer {
    static ESLLogger logger = ESLLogger.getLogger(OptionsTableCellRenderer.class);
    private BooleanStringConverter booleanStringConverter = new BooleanStringConverter();
    private static final Icon DEFAULT_CLOSED_ICON = new NodeIcon('+');
    private static final Icon DEFAULT_OPEN_ICON = new NodeIcon('-');
    private final EventDispatcher eventDispatcher;
    private final ViewState viewState;
    private Map<CellComponentEntry, Component> map = new HashMap<CellComponentEntry, Component>();

    public OptionsTableCellRenderer(EventDispatcher eventDispatcher, ViewState viewState) {
        this.eventDispatcher = eventDispatcher;
        this.viewState = viewState;
    }

    public Component add(Component comp, OptionsTableEntry value, int col) {
        CellComponentEntry entry = new CellComponentEntry(value, col);
        if (this.map.containsKey(entry)) {
            return this.map.get(entry);
        }
        if (col == 1) {
            comp.setBackground(Color.WHITE);
        }
        this.map.put(entry, comp);
        return comp;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Object key = table.getModel().getValueAt(row, 0);
        final OptionsTableEntry optionEntry = (OptionsTableEntry)table.getModel().getValueAt(row, 1);
        DisplayableOption option = optionEntry.getDisplayableOption();
        if (column == 0) {
            return this.add(this.getKeyComponent((OptionsTableModel)table.getModel(), row, key.toString(), optionEntry, option != null ? option.getToolTip() : null), optionEntry, column);
        }
        if (option != null) {
            if (option.getOptionType().equals("BooleanOption")) {
                try {
                    return this.add(this.getCheckBox("", this.booleanStringConverter.reconvert(option.getValue())), optionEntry, column);
                }
                catch (ConversionException exc) {
                    logger.logExceptionIfDebugEnabled(exc);
                    return this.getCheckBox("", false);
                }
            }
            if (option.getOptionType().equals("EnumOption")) {
                return this.add(this.getEnumComponent(key.toString(), option, table, row), optionEntry, column);
            }
            if (option.getOptionType().equals("StringChoiceOption")) {
                return this.add(this.getLabel(option.getValue()), optionEntry, column);
            }
            if (option.getOptionType().equals("ColorOption")) {
                return this.add(new ColorTableCell(option, this.eventDispatcher, this.viewState).getPanel(table, row), optionEntry, column);
            }
            if (key.toString().equals("font-family") || key.toString().equals("fontName")) {
                return this.add(this.getLabel(option.getValue()), optionEntry, column);
            }
            if (optionEntry.getPath().getFirstElement().equals("rotation") && this.viewState.getElementFocused() < 0) {
                return this.add(this.getLabel(option.getValue()), optionEntry, column);
            }
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)this.getLabel(option.getValue()), "Center");
            JButton button = new JButton("...");
            button.setMargin(new Insets(1, 1, 1, 1));
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ShowEditOptionDialogEvent event = new ShowEditOptionDialogEvent(OptionsTableCellRenderer.this.viewState.getElementFocused(), optionEntry.getPath(), optionEntry.getDisplayableOption());
                    OptionsTableCellRenderer.this.eventDispatcher.dispatchEvent(event);
                }
            });
            panel.add((Component)button, "East");
            return this.add(panel, optionEntry, column);
        }
        return null;
    }

    private Component getEnumComponent(String key, DisplayableOption option, JTable table, int row) {
        block8: {
            if (option.isEnum()) {
                try {
                    Class<?> enumClass = option.getEnum().getClass();
                    Field[] fields = enumClass.getDeclaredFields();
                    ArrayList<String> enumNames = new ArrayList<String>();
                    for (Field field : fields) {
                        if (!field.isEnumConstant()) continue;
                        enumNames.add(field.getName());
                    }
                    if (enumNames.size() == 2) {
                        if (IconUtils.isIconAvailable(key)) {
                            String enabledValue = ((String)enumNames.get(0)).equals("normal") || ((String)enumNames.get(0)).equals("none") ? ((String)enumNames.get(0)).toLowerCase() : ((String)enumNames.get(1)).toLowerCase();
                            String disabledvalue = ((String)enumNames.get(0)).equals("normal") || ((String)enumNames.get(0)).equals("none") ? ((String)enumNames.get(1)).toLowerCase() : ((String)enumNames.get(0)).toLowerCase();
                            return new SingleButtonEditor(this.eventDispatcher, this.viewState.getElementFocused(), option, IconUtils.loadImageIcon(key), enabledValue, disabledvalue).getPanel(table, row);
                        }
                        break block8;
                    }
                    TreeMap<String, ImageIcon> icons = new TreeMap<String, ImageIcon>();
                    for (String enumName : enumNames) {
                        String iconName = String.format("%s_%s", key, enumName.toLowerCase());
                        if (IconUtils.isIconAvailable(iconName)) {
                            icons.put(enumName, IconUtils.loadImageIcon(iconName));
                            continue;
                        }
                        return this.getLabel(option.getValue());
                    }
                    return new ButtonEditor(this.eventDispatcher, this.viewState.getElementFocused(), option, icons).getPanel(table, row);
                }
                catch (Exception exc) {
                    logger.logExceptionIfDebugEnabled(exc);
                }
            }
        }
        return this.getLabel(option.getValue());
    }

    public Component getKeyComponent(final OptionsTableModel optionsTableModel, int row, String key, final OptionsTableEntry optionEntry, String toolTip) {
        if (optionEntry.getDisplayableOption() != null) {
            JLabel label = this.getLabel(key, optionEntry.getPath().getSize());
            if (toolTip != null) {
                int indexOf = toolTip.indexOf("Example");
                if (indexOf >= 0) {
                    toolTip = toolTip.substring(0, indexOf);
                }
                label.setToolTipText(toolTip);
            }
            return label;
        }
        JPanel panel = new JPanel(new SpringLayout());
        final JButton button = new JButton(DEFAULT_OPEN_ICON);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.addActionListener(new ActionListener(){
            private boolean isOpen = true;

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (isOpen) {
                            isOpen = false;
                            button.setIcon(DEFAULT_CLOSED_ICON);
                            this.setChildsVisible(false);
                        } else {
                            button.setIcon(DEFAULT_OPEN_ICON);
                            this.setChildsVisible(true);
                            isOpen = true;
                        }
                        optionsTableModel.fireTableDataChanged();
                    }

                    private void setChildsVisible(boolean visible) {
                        int startIndex;
                        int currentDepth = optionEntry.getPath().getSize();
                        List<OptionsTableEntry> rows = optionsTableModel.getAllRows();
                        for (int index = startIndex = rows.indexOf(optionEntry) + 1; index < rows.size(); ++index) {
                            OptionsTableEntry row = rows.get(index);
                            if (row.getPath().getSize() <= currentDepth) continue;
                            row.setVisible(visible);
                        }
                    }
                });
            }
        });
        panel.add(button);
        JLabel label = this.getLabel(key, optionEntry.getPath().getSize());
        panel.setBorder(label.getBorder());
        label.setBorder(null);
        panel.add(label);
        SpringUtilities.makeCompactGrid(panel, 1, 2, 0, 0, 3, 0);
        panel.setToolTipText(toolTip);
        return panel;
    }

    private JLabel getLabel(String text, int depth) {
        JLabel label = this.getLabel(text);
        label.setBorder(new EmptyBorder(0, depth * 10, 0, 0));
        return label;
    }

    private JLabel getLabel(String text) {
        return new JLabel(text);
    }

    private JCheckBox getCheckBox(String text, boolean checked) {
        return new JCheckBox(text, checked);
    }
}

