/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.gui;

import at.mrdevelopment.toolkit.gui.IconUtils;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class SplitButton
extends JButton {
    private JLabel leftButton;
    private JLabel rightButton;
    private JPopupMenu popupMenu;
    private ActionListener leftButtonActionListener;
    private JSeparator separator = new JSeparator(1);

    public SplitButton(JLabel leftButton, ActionListener leftButtonActionListener, JPopupMenu popupMenu) {
        this.leftButton = leftButton;
        this.leftButtonActionListener = leftButtonActionListener;
        leftButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                SplitButton.this.doClick();
                SplitButton.this.handleLeftButton(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SplitButton.this.getModel().setRollover(false);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (SplitButton.this.isRolloverEnabled()) {
                    SplitButton.this.getModel().setRollover(true);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        this.popupMenu = popupMenu;
        this.rightButton = new JLabel(IconUtils.loadIcon("splitButtonDropDown"));
        this.rightButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                SplitButton.this.doClick();
                SplitButton.this.handlePopupButton();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SplitButton.this.getModel().setRollover(false);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (SplitButton.this.isRolloverEnabled()) {
                    SplitButton.this.getModel().setRollover(true);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        this.setFocusable(false);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                SplitButton.this.doClick();
                if (e.getX() < SplitButton.this.separator.getX()) {
                    SplitButton.this.handleLeftButton(e);
                } else {
                    SplitButton.this.handlePopupButton();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (SplitButton.this.isRolloverEnabled()) {
                    SplitButton.this.getModel().setRollover(true);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        this.setLayout(new BoxLayout(this, 2));
        this.add(leftButton);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.add(this.separator);
        this.add(Box.createRigidArea(new Dimension(2, 0)));
        this.add(this.rightButton);
        this.add(Box.createRigidArea(new Dimension(2, 0)));
    }

    private void handleLeftButton(MouseEvent event) {
        if (this.leftButtonActionListener != null) {
            this.leftButtonActionListener.actionPerformed(new ActionEvent(event.getSource(), event.getID(), "click"));
        }
    }

    private void handlePopupButton() {
        if (this.popupMenu.isVisible()) {
            this.popupMenu.setVisible(false);
        } else {
            this.popupMenu.pack();
            Point pos = new Point();
            pos.x = 0;
            pos.y = this.getHeight() - 1;
            this.popupMenu.show(this, pos.x, pos.y);
            this.popupMenu.setVisible(true);
        }
    }

    public JLabel getLeftButton() {
        return this.leftButton;
    }

    public JLabel getRightButton() {
        return this.rightButton;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public ActionListener getLeftButtonActionListener() {
        return this.leftButtonActionListener;
    }
}

