/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.gui;

import at.mrdevelopment.toolkit.Progress;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class ProgressTableCellRenderer
implements TableCellRenderer {
    private static final Color SUCCESSFUL_TEXT_COLOR = new Color(15, 127, 15);
    private static final Color FAILED_TEXT_COLOR = Color.RED;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value != null) {
            Progress progress = (Progress)value;
            if (progress.isFinished()) {
                JLabel label = new JLabel(progress.getText());
                label.setOpaque(true);
                label.setHorizontalAlignment(0);
                Color foreground = progress.isFailed() ? FAILED_TEXT_COLOR : SUCCESSFUL_TEXT_COLOR;
                label.setForeground(isSelected ? table.getSelectionForeground() : foreground);
                label.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                return label;
            }
            JProgressBar progressBar = new JProgressBar((Integer)progress.getMin(), (Integer)progress.getMax());
            progressBar.setStringPainted(true);
            progressBar.setString(progress.getText());
            progressBar.setValue((Integer)progress.getValue());
            return progressBar;
        }
        return null;
    }
}

