/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.gui;

import at.mrdevelopment.toolkit.problem.Problem;
import at.mrdevelopment.toolkit.problem.ProblemSeverity;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ProblemListModel
implements ListModel {
    private final SortedSet<Problem> problems = new TreeSet<Problem>(new Comparator<Problem>(){

        @Override
        public int compare(Problem left, Problem right) {
            int value = left.getSeverity().getPriorityLevel() - right.getSeverity().getPriorityLevel();
            if (value != 0) {
                return value;
            }
            return left.getIdentifier().compareTo(right.getIdentifier());
        }
    });
    private final List<ListDataListener> listeners = new CopyOnWriteArrayList<ListDataListener>();
    private int nonInfoCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProblems(Collection<Problem> problems) {
        int oldSize;
        ProblemListModel problemListModel = this;
        synchronized (problemListModel) {
            oldSize = this.problems.size();
            this.problems.clear();
            this.problems.addAll(problems);
            this.nonInfoCount = Collections2.filter(problems, (Predicate)new Predicate<Problem>(){

                public boolean apply(Problem problem) {
                    return problem.getSeverity() != ProblemSeverity.INFO;
                }
            }).size();
        }
        for (ListDataListener listener : this.listeners) {
            if (oldSize < problems.size()) {
                ListDataEvent addedEvent = new ListDataEvent(this, 1, oldSize, problems.size() - 1);
                listener.intervalAdded(addedEvent);
            }
            if (oldSize > problems.size()) {
                ListDataEvent removedEvent = new ListDataEvent(this, 2, problems.size(), oldSize - 1);
                listener.intervalRemoved(removedEvent);
            }
            if (problems.size() <= 0) continue;
            ListDataEvent changedEvent = new ListDataEvent(this, 0, 0, problems.size() - 1);
            listener.contentsChanged(changedEvent);
        }
    }

    public synchronized int getNonInfoProblemsCount() {
        return this.nonInfoCount;
    }

    @Override
    public synchronized int getSize() {
        return this.problems.size();
    }

    public synchronized Problem getElementAt(int index) {
        return this.problems.toArray(new Problem[this.problems.size()])[index];
    }

    @Override
    public void addListDataListener(ListDataListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListDataListener(ListDataListener listener) {
        this.listeners.remove(listener);
    }
}

