/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.gui;

import at.mrdevelopment.toolkit.gui.MissingIcon;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class IconUtils {
    private static final String ICON_PATH = "/icons/";
    private static final String ICON_EXTENSION = ".png";

    public static Icon loadIcon(Class<?> classForIcon) {
        return IconUtils.loadIcon(classForIcon.getSimpleName());
    }

    public static Icon loadIcon(String name) {
        return IconUtils.loadIcon(IconUtils.getIconRessource(name));
    }

    public static ImageIcon loadImageIcon(String name) {
        return IconUtils.loadImageIcon(IconUtils.getIconRessource(name));
    }

    public static BufferedImage loadImage(String name) {
        try {
            return ImageIO.read(IconUtils.getIconRessource(name));
        }
        catch (IOException exc) {
            ImageIcon imageIcon = IconUtils.loadImageIcon(name);
            BufferedImage image = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 1);
            Graphics2D g = image.createGraphics();
            imageIcon.paintIcon(null, g, 0, 0);
            g.dispose();
            return image;
        }
    }

    private static URL getIconRessource(String name) {
        return IconUtils.class.getResource(ICON_PATH + name + ICON_EXTENSION);
    }

    private static Icon loadIcon(URL ressource) {
        return ressource != null ? new ImageIcon(ressource) : new MissingIcon(16, 16);
    }

    private static ImageIcon loadImageIcon(URL ressource) {
        return ressource != null ? new ImageIcon(ressource) : new ImageIcon(new MissingIcon(16, 16).toImage());
    }

    public static boolean isIconAvailable(String name) {
        return IconUtils.getIconRessource(name) != null;
    }
}

