/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.gui;

import at.mrdevelopment.toolkit.log.ESLLogger;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class GUIUtils {
    static ESLLogger logger = ESLLogger.getLogger(GUIUtils.class);

    public static void setSystemLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exc) {
            logger.warn("System look and feel not supported.");
        }
    }

    public static JComboBox getComboBox(List<String> choices, String selected) {
        Object[] objects = new Object[choices.size()];
        int i = 0;
        int selectedIndex = 0;
        for (String choice : choices) {
            objects[i] = choice;
            if (choice.equals(selected)) {
                selectedIndex = i;
            }
            ++i;
        }
        JComboBox<Object> comboBox = new JComboBox<Object>(objects);
        comboBox.setSelectedIndex(selectedIndex);
        return comboBox;
    }

    public static void issueErrorPopup(Component parent, Exception e) {
        String errname = e.getClass().getSimpleName();
        JOptionPane.showMessageDialog(parent, errname + ". " + e.getMessage(), errname, 0);
    }

    public static void issueErrorPopup(Component parent, String msg) {
        JOptionPane.showMessageDialog(parent, msg, "Error", 0);
    }

    public static boolean issueConfirmPopup(Component parent, String msg, String title) {
        return JOptionPane.showConfirmDialog(parent, msg, title, 0) == 0;
    }

    public static void issueNotificationPopup(Component parent, String msg, String title) {
        JOptionPane.showMessageDialog(parent, msg, title, 1);
    }

    public static Border createBorder(String title) {
        return GUIUtils.createBorder(title, 5, 5, 0, 5);
    }

    public static Border createBorder(String title, int top, int left, int bottom, int right) {
        return BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(top, left, bottom, right), BorderFactory.createTitledBorder(title));
    }

    public static void addEscapeListener(JDialog dialog, ActionListener actionListener) {
        dialog.getRootPane().registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(27, 0), 2);
    }
}

