/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.gui;

import java.awt.Point;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class AutoDockingDesktopManager
extends DefaultDesktopManager {
    private static final int DOCKING_DISTANCE = 15;

    @Override
    public void dragFrame(JComponent component, int x, int y) {
        if (component instanceof JInternalFrame) {
            JInternalFrame frame = (JInternalFrame)component;
            JDesktopPane desktop = frame.getDesktopPane();
            int desktopWidth = desktop.getSize().width;
            int desktopHeight = desktop.getSize().height;
            int frameWidth = frame.getSize().width;
            int frameHeight = frame.getSize().height;
            Point topLeft = new Point(x, y);
            Point bottomRight = new Point(x + frameWidth, y + frameHeight);
            this.dragTo(frame, topLeft, bottomRight, new Point(0, 0));
            this.dragTo(frame, topLeft, bottomRight, new Point(desktopWidth, desktopHeight));
            for (JInternalFrame otherFrame : desktop.getAllFrames()) {
                if (frame.equals(otherFrame)) continue;
                this.dragTo(frame, topLeft, bottomRight, new Point(otherFrame.getLocation().x, otherFrame.getLocation().y));
                this.dragTo(frame, topLeft, bottomRight, new Point(otherFrame.getLocation().x + otherFrame.getSize().width, otherFrame.getLocation().y + otherFrame.getSize().height));
            }
            if (frameWidth <= desktopWidth) {
                topLeft.x = Math.min(topLeft.x, desktopWidth - frameWidth);
            }
            if (frameHeight <= desktopHeight) {
                topLeft.y = Math.min(topLeft.y, desktopHeight - frameHeight);
            }
            topLeft.x = Math.max(topLeft.x, 0);
            topLeft.y = Math.max(topLeft.y, 0);
            super.dragFrame(component, topLeft.x, topLeft.y);
        }
    }

    @Override
    public void resizeFrame(JComponent component, int x, int y, int w, int h) {
        if (component instanceof JInternalFrame) {
            JInternalFrame frame = (JInternalFrame)component;
            JDesktopPane desktop = frame.getDesktopPane();
            int desktopWidth = desktop.getSize().width;
            int desktopHeight = desktop.getSize().height;
            Point topLeft = new Point(x, y);
            Point bottomRight = new Point(x + w, y + h);
            this.resizeTo(frame, topLeft, bottomRight, new Point(0, 0));
            this.resizeTo(frame, topLeft, bottomRight, new Point(desktopWidth, desktopHeight));
            for (JInternalFrame otherFrame : desktop.getAllFrames()) {
                if (frame.equals(otherFrame)) continue;
                this.resizeTo(frame, topLeft, bottomRight, new Point(otherFrame.getLocation().x, otherFrame.getLocation().y));
                this.resizeTo(frame, topLeft, bottomRight, new Point(otherFrame.getLocation().x + otherFrame.getSize().width, otherFrame.getLocation().y + otherFrame.getSize().height));
            }
            super.resizeFrame(frame, topLeft.x, topLeft.y, bottomRight.x - topLeft.x, bottomRight.y - topLeft.y);
        }
    }

    private void resizeTo(JInternalFrame frame, Point topLeft, Point bottomRight, Point snapTo) {
        if (Math.abs(topLeft.x - snapTo.x) < 15) {
            topLeft.x = snapTo.x;
            bottomRight.x += topLeft.x - snapTo.x;
        }
        if (Math.abs(bottomRight.x - snapTo.x) < 15) {
            bottomRight.x -= bottomRight.x - snapTo.x;
        }
        if (Math.abs(topLeft.y - snapTo.y) < 15) {
            topLeft.y = snapTo.y;
            bottomRight.y += topLeft.y - snapTo.y;
        }
        if (Math.abs(bottomRight.y - snapTo.y) < 15) {
            bottomRight.y -= bottomRight.y - snapTo.y;
        }
    }

    private void dragTo(JInternalFrame frame, Point topLeft, Point bottomRight, Point snapTo) {
        int width = bottomRight.x - topLeft.x;
        int height = bottomRight.y - topLeft.y;
        if (Math.abs(topLeft.x - snapTo.x) < 15) {
            topLeft.x = snapTo.x;
            bottomRight.x = topLeft.x + width;
        }
        if (Math.abs(bottomRight.x - snapTo.x) < 15) {
            bottomRight.x -= bottomRight.x - snapTo.x;
            topLeft.x = bottomRight.x - width;
        }
        if (Math.abs(topLeft.y - snapTo.y) < 15) {
            topLeft.y = snapTo.y;
            bottomRight.y = topLeft.y + height;
        }
        if (Math.abs(bottomRight.y - snapTo.y) < 15) {
            bottomRight.y -= bottomRight.y - snapTo.y;
            topLeft.y = bottomRight.y - height;
        }
    }
}

