/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.firmware;

import at.mrdevelopment.toolkit.FirmwareImage;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.xml.SerializeException;

public class Firmware
implements Comparable<Firmware> {
    private static final int BOOTLOADER_SIZE = 2048;
    private static final int FIRMWARE_SIZE = 29696;
    private static final int INFO_BLOCK_VERSION_ADDRESS = 29693;
    private static final int FIRMWARE_VERSION_ADDRESS = 29692;
    private static final int DEVICE_TYPE_ADDRESS = 29691;
    private static final int INFO_BLOCK_VERSION_1 = 1;
    private final int deviceType;
    private final Version version;
    private final FirmwareImage firmwareImage;
    private boolean forceFirmwareUpdate;

    public Firmware(FirmwareImage firmwareImage) throws SerializeException {
        this(firmwareImage, false);
    }

    public Firmware(FirmwareImage firmwareImage, boolean forceFirmwareUpdate) throws SerializeException {
        this.firmwareImage = firmwareImage;
        if (firmwareImage.getSize() != 29696) {
            throw new SerializeException("Wrong firmware image size", new Object[0]);
        }
        if (firmwareImage.getByte(29693) != 1) {
            throw new SerializeException("Unsupported info block version %02X", firmwareImage.getByte(29693));
        }
        this.deviceType = firmwareImage.getByte(29691);
        this.version = Version.fromByte(firmwareImage.getByte(29692));
        this.forceFirmwareUpdate = forceFirmwareUpdate;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean getForceUpdateFlag() {
        return this.forceFirmwareUpdate;
    }

    public FirmwareImage getFirmwareImage() {
        return this.firmwareImage;
    }

    public void clearForceUpdateFlag() {
        this.forceFirmwareUpdate = false;
    }

    @Override
    public int compareTo(Firmware other) {
        return this.version.compareTo(other.version);
    }
}

