/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.file;

import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.file.AbstractImportReport;
import at.mrdevelopment.toolkit.file.CsvConfiguration;
import at.mrdevelopment.toolkit.file.ImportRecordException;
import at.mrdevelopment.toolkit.file.RecordImport;
import at.mrdevelopment.toolkit.file.RecordReader;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Collections;
import java.util.regex.Pattern;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class FtpRecordImport<R extends AbstractImportReport<?, ? extends Enum<?>>>
implements RecordImport {
    static ESLLogger logger = ESLLogger.getLogger(FtpRecordImport.class);
    private final RecordReader<R> recordReader;
    private final CsvConfiguration configuration;

    public FtpRecordImport(RecordReader<R> recordReader, CsvConfiguration configuration) {
        this.recordReader = recordReader;
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void importRecords() throws ImportRecordException {
        String host = this.configuration.getFtpHost();
        int port = this.configuration.getFtpPort();
        String username = this.configuration.getFtpLogin();
        String password = this.configuration.getFtpPassword();
        String directory = this.configuration.getImportDirectory();
        Pattern filePattern = this.configuration.getImportFilePattern();
        FTPClient ftpClient = null;
        try {
            ftpClient = this.connect(host, port, username, password);
            if (ftpClient == null) {
                throw new ImportRecordException("Could not connect to FTP host", new Object[0]);
            }
            logger.debug("Connected to %s", ftpClient.getRemoteAddress().toString());
            if (username != null && password != null && !ftpClient.login(username, password)) {
                throw new ImportRecordException("Could not login to FTP host", new Object[0]);
            }
            int reply = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                throw new ImportRecordException("FTP host refused connection (reply code was %d)", reply);
            }
            if (directory != null && !directory.isEmpty() && !ftpClient.changeWorkingDirectory(directory)) {
                throw new ImportRecordException("Failed to change to directory %s", directory);
            }
            FTPFile[] arr$ = ftpClient.listFiles();
            int len$ = arr$.length;
            int i$ = 0;
            while (true) {
                block24: {
                    InputStream inputStream;
                    block23: {
                        if (i$ >= len$) {
                            this.disconnect(ftpClient);
                            return;
                        }
                        FTPFile file = arr$[i$];
                        if (file == null || !filePattern.matcher(file.getName()).matches()) break block24;
                        R report = this.recordReader.createNewReport();
                        inputStream = null;
                        try {
                            block26: {
                                block27: {
                                    int replyCode;
                                    block25: {
                                        logger.info("Downloading file %s", file.getName());
                                        inputStream = ftpClient.retrieveFileStream(file.getName());
                                        if (inputStream == null) {
                                            throw new ImportRecordException("Failed to download import file %s (Could not open stream)", file.getName());
                                        }
                                        this.recordReader.readRecords(file.getName(), inputStream, report, Collections.<String, String>emptyMap());
                                        boolean success = ftpClient.completePendingCommand();
                                        replyCode = ftpClient.getReplyCode();
                                        if (!success || !FTPReply.isPositiveCompletion((int)replyCode)) break block25;
                                        logger.info("Import of file %s finished", file.getName());
                                        if (!this.configuration.isDeleteFileAfterImport()) break block26;
                                        break block27;
                                    }
                                    throw new ImportRecordException("Failed to download import file %s (reply code was %d)", file.getName(), replyCode);
                                }
                                if (!ftpClient.deleteFile(file.getName())) {
                                    logger.warn("Failed to delete %s", file.getName());
                                }
                            }
                            if (!this.configuration.isWriteImportReport()) break block23;
                            String reportFileName = AbstractImportReport.getReportFileNameFromImportFileName(file.getName());
                            logger.info("Writing import report to %s", reportFileName);
                            OutputStream outputStream = null;
                            try {
                                outputStream = ftpClient.storeFileStream(reportFileName);
                                if (outputStream != null) {
                                    ((AbstractImportReport)report).writeTo(outputStream);
                                    outputStream.close();
                                    boolean success2 = ftpClient.completePendingCommand();
                                    int replyCode2 = ftpClient.getReplyCode();
                                    if (success2 && FTPReply.isPositiveCompletion((int)replyCode2)) {
                                        logger.info("Import report upload finished");
                                        break block23;
                                    } else {
                                        logger.warn("Failed to upload import report (reply code was %d)", replyCode2);
                                    }
                                    break block23;
                                }
                                logger.warn("Failed to upload import report (Could not open stream)", reportFileName);
                            }
                            finally {
                                StreamUtils.close(outputStream);
                            }
                        }
                        catch (ImportRecordException exc) {
                            try {
                                throw exc;
                                catch (Exception exc2) {
                                    throw new ImportRecordException(exc2);
                                }
                            }
                            catch (Throwable throwable) {
                                StreamUtils.close(inputStream);
                                throw throwable;
                            }
                        }
                    }
                    StreamUtils.close(inputStream);
                }
                ++i$;
            }
        }
        catch (IOException exc) {
            try {
                throw new ImportRecordException(exc);
            }
            catch (Throwable throwable) {
                this.disconnect(ftpClient);
                throw throwable;
            }
        }
    }

    private FTPClient connect(String host, int port, String username, String password) throws SocketException, IOException {
        FTPClient ftpClient = new FTPClient();
        ftpClient.connect(host, port);
        ftpClient.enterLocalPassiveMode();
        return ftpClient;
    }

    private void disconnect(FTPClient ftpClient) {
        if (ftpClient != null && ftpClient.isConnected()) {
            try {
                logger.debug("Disconnecting from %s", ftpClient.getRemoteAddress().toString());
                ftpClient.disconnect();
            }
            catch (Exception exc) {
                logger.logException(exc);
            }
        }
    }
}

