/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.file;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public class FileUtils {
    public static final int DEFAULT_SHORTENER_THRESHOLD = 4;
    public static final String SHORTENER_BACKSLASH_REGEX = "\\\\";
    public static final String SHORTENER_SLASH_REGEX = "/";
    public static final String SHORTENER_BACKSLASH = "\\";
    public static final String SHORTENER_SLASH = "/";
    public static final String SHORTENER_ELLIPSE = "...";

    public static void save(String data, String path) throws IOException {
        FileUtils.save(data, new File(path));
    }

    public static void save(String data, File file) throws IOException {
        org.apache.commons.io.FileUtils.writeStringToFile((File)file, (String)data);
    }

    public static String read(String path) throws IOException {
        return FileUtils.read(new File(path));
    }

    public static String read(File file) throws IOException {
        return org.apache.commons.io.FileUtils.readFileToString((File)file);
    }

    public static List<String> readLines(File file) throws IOException {
        return org.apache.commons.io.FileUtils.readLines((File)file);
    }

    public static String removeExtension(String fileName) {
        return FilenameUtils.removeExtension((String)fileName);
    }

    public static void moveFile(File srcFile, File destFile) throws IOException {
        org.apache.commons.io.FileUtils.moveFile((File)srcFile, (File)destFile);
    }

    public static boolean deleteQuietly(File file) {
        return org.apache.commons.io.FileUtils.deleteQuietly((File)file);
    }

    public static FileFilter newFileExtensionFilter(final String extension) {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file == null) {
                    return false;
                }
                return FilenameUtils.getExtension((String)file.getName()).equalsIgnoreCase(extension);
            }
        };
    }

    public static String getRelativePath(String targetPath, String basePath, String pathSeparator) {
        int commonIndex;
        String normalizedTargetPath = FilenameUtils.normalizeNoEndSeparator((String)targetPath);
        String normalizedBasePath = FilenameUtils.normalizeNoEndSeparator((String)basePath);
        if (pathSeparator.equals("/")) {
            normalizedTargetPath = FilenameUtils.separatorsToUnix((String)normalizedTargetPath);
            normalizedBasePath = FilenameUtils.separatorsToUnix((String)normalizedBasePath);
        } else if (pathSeparator.equals(SHORTENER_BACKSLASH)) {
            normalizedTargetPath = FilenameUtils.separatorsToWindows((String)normalizedTargetPath);
            normalizedBasePath = FilenameUtils.separatorsToWindows((String)normalizedBasePath);
        } else {
            throw new IllegalArgumentException("Unrecognised dir separator '" + pathSeparator + "'");
        }
        String[] base = normalizedBasePath.split(Pattern.quote(pathSeparator));
        String[] target = normalizedTargetPath.split(Pattern.quote(pathSeparator));
        StringBuilder common = new StringBuilder();
        for (commonIndex = 0; commonIndex < target.length && commonIndex < base.length && target[commonIndex].equals(base[commonIndex]); ++commonIndex) {
            common.append(target[commonIndex] + pathSeparator);
        }
        if (commonIndex == 0) {
            throw new PathResolutionException("No common path element found for '" + normalizedTargetPath + "' and '" + normalizedBasePath + "'");
        }
        boolean baseIsFile = true;
        File baseResource = new File(normalizedBasePath);
        if (baseResource.exists()) {
            baseIsFile = baseResource.isFile();
        } else if (basePath.endsWith(pathSeparator)) {
            baseIsFile = false;
        }
        StringBuilder relative = new StringBuilder();
        if (base.length != commonIndex) {
            int numDirsUp = baseIsFile ? base.length - commonIndex - 1 : base.length - commonIndex;
            for (int i = 0; i < numDirsUp; ++i) {
                relative.append(".." + pathSeparator);
            }
        }
        relative.append(normalizedTargetPath.substring(common.length()));
        return relative.toString();
    }

    static class PathResolutionException
    extends RuntimeException {
        PathResolutionException(String msg) {
            super(msg);
        }
    }
}

