/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.file;

import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.file.AbstractImportReport;
import at.mrdevelopment.toolkit.file.CsvConfiguration;
import at.mrdevelopment.toolkit.file.ImportRecordException;
import at.mrdevelopment.toolkit.file.RecordImport;
import at.mrdevelopment.toolkit.file.RecordReader;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class FileRecordImport<R extends AbstractImportReport<?, ? extends Enum<?>>>
implements RecordImport {
    static ESLLogger logger = ESLLogger.getLogger(FileRecordImport.class);
    private final RecordReader<R> recordReader;
    private final CsvConfiguration configuration;

    public FileRecordImport(RecordReader<R> recordReader, CsvConfiguration configuration) {
        this.recordReader = recordReader;
        this.configuration = configuration;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void importRecords() throws ImportRecordException {
        File directory = this.getImportDirectory();
        Pattern filePattern = this.configuration.getImportFilePattern();
        if (!directory.exists()) {
            throw new ImportRecordException("Import directory %s does not exists", directory.getPath());
        }
        File[] arr$ = directory.listFiles();
        int len$ = arr$.length;
        int i$ = 0;
        while (i$ < len$) {
            File file = arr$[i$];
            if (file != null && filePattern.matcher(file.getName()).matches()) {
                logger.debug("Importing from file %s", file.getName());
                R report = this.recordReader.createNewReport();
                FileInputStream inputStream = null;
                try {
                    inputStream = new FileInputStream(file);
                    inputStream.getChannel().lock(0L, Long.MAX_VALUE, true);
                    this.recordReader.readRecords(file.getName(), inputStream, report, Collections.<String, String>emptyMap());
                    if (this.configuration.isDeleteFileAfterImport()) {
                        try {
                            file.delete();
                        }
                        catch (SecurityException exc) {
                            logger.warn("Failed to delete %s", file.getName());
                        }
                    }
                    if (this.configuration.isMoveFileAfterImport() && !this.configuration.isDeleteFileAfterImport()) {
                        try {
                            File destFile = new File(new File(this.configuration.getMoveDirectory()), file.getName());
                            if (destFile.exists()) {
                                FileUtils.deleteQuietly((File)destFile);
                            }
                            FileUtils.moveFileToDirectory((File)file, (File)new File(this.configuration.getMoveDirectory()), (boolean)true);
                        }
                        catch (IOException exc) {
                            logger.warn("Failed to move file %s to %s", file.getName(), this.configuration.getMoveDirectory());
                            logger.logExceptionIfDebugEnabled(exc);
                        }
                    }
                    if (this.configuration.isWriteImportReport()) {
                        try {
                            File reportFile = new File(directory, AbstractImportReport.getReportFileNameFromImportFileName(file.getName()));
                            ((AbstractImportReport)report).writeToFile(reportFile);
                        }
                        catch (Exception exc) {
                            logger.warn("Failed to write import report");
                        }
                    }
                }
                catch (ImportRecordException exc) {
                    try {
                        throw exc;
                        catch (Exception exc2) {
                            throw new ImportRecordException(exc2);
                        }
                    }
                    catch (Throwable throwable) {
                        StreamUtils.close(inputStream);
                        throw throwable;
                    }
                }
                StreamUtils.close(inputStream);
            }
            ++i$;
        }
        return;
    }

    private File getImportDirectory() {
        String directory = this.configuration.getImportDirectory();
        return directory != null && !directory.isEmpty() ? new File(directory) : new File(".");
    }
}

