/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.file;

import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang.StringUtils;

public class CsvReader {
    static ESLLogger logger = ESLLogger.getLogger(CsvReader.class);
    private final String delimiter;
    private final boolean skipHeaderLine;

    public CsvReader() {
        this(";", false);
    }

    public CsvReader(String delimiter, boolean skipHeaderLine) {
        this.delimiter = delimiter;
        this.skipHeaderLine = skipHeaderLine;
    }

    public List<String[]> read(File importFile) throws IOException, FileNotFoundException {
        return this.read(importFile, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String[]> read(File importFile, String charsetName) throws IOException, FileNotFoundException, UnsupportedEncodingException {
        List<String[]> list;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(importFile);
            inputStream.getChannel().lock(0L, Long.MAX_VALUE, true);
            list = this.read(inputStream, charsetName);
        }
        catch (Throwable throwable) {
            StreamUtils.close(inputStream);
            throw throwable;
        }
        StreamUtils.close(inputStream);
        return list;
    }

    public List<String[]> read(InputStream inputStream) throws IOException {
        return this.read(inputStream, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String[]> read(InputStream inputStream, String charsetName) throws IOException, UnsupportedEncodingException {
        ArrayList<String[]> arrayList;
        BufferedReader reader = null;
        try {
            BOMInputStream bomInputStream = new BOMInputStream(inputStream, new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_32BE, ByteOrderMark.UTF_32LE});
            if (bomInputStream.hasBOM()) {
                charsetName = bomInputStream.getBOMCharsetName();
                logger.info("Using charset %s from stream", charsetName);
            } else {
                logger.debug("Using charset %s", charsetName);
            }
            reader = new BufferedReader(new InputStreamReader((InputStream)bomInputStream, charsetName));
            ArrayList<String[]> lines = new ArrayList<String[]>();
            String line = reader.readLine();
            while (line != null) {
                if (!line.trim().isEmpty() && !line.startsWith("#")) {
                    String[] record = this.readLine(line);
                    lines.add(record);
                }
                line = reader.readLine();
            }
            arrayList = this.skipHeaderLine ? lines.subList(1, lines.size()) : lines;
        }
        catch (Throwable throwable) {
            StreamUtils.close(reader);
            throw throwable;
        }
        StreamUtils.close(reader);
        return arrayList;
    }

    private String[] readLine(String line) {
        return StringUtils.splitPreserveAllTokens((String)line, (String)this.delimiter);
    }
}

